/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.util;

import cascading.flow.stream.MemorySpliceGate;
import cascading.tuple.Fields;
import cascading.tuple.Hasher;
import cascading.tuple.Tuple;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleHasher
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MemorySpliceGate.class);
    private static Hasher DEFAULT = new ObjectHasher();
    private Hasher[] hashers;

    public TupleHasher() {
    }

    public TupleHasher(Comparator defaultComparator, Comparator[] comparators) {
        this.initialize(defaultComparator, comparators);
    }

    public static Comparator[] merge(Fields[] keyFields) {
        Comparator[] comparators = new Comparator[keyFields[0].size()];
        for (Fields keyField : keyFields) {
            if (keyField == null) continue;
            for (int i = 0; i < keyField.getComparators().length; ++i) {
                Comparator comparator = keyField.getComparators()[i];
                if (!(comparator instanceof Hasher)) continue;
                if (comparators[i] != null && !((Object)comparators[i]).equals(comparator)) {
                    LOG.warn("two unequal Hasher instances for the same key field position found: {}, and: {}", (Object)comparators[i], (Object)comparator);
                }
                comparators[i] = comparator;
            }
        }
        return comparators;
    }

    public static boolean isNull(Comparator[] comparators) {
        int count2 = 0;
        for (Comparator comparator : comparators) {
            if (comparator != null) continue;
            ++count2;
        }
        return count2 == comparators.length;
    }

    protected void initialize(Comparator defaultComparator, Comparator[] comparators) {
        Hasher defaultHasher = DEFAULT;
        if (defaultComparator instanceof Hasher) {
            defaultHasher = (Hasher)((Object)defaultComparator);
        }
        this.hashers = new Hasher[comparators.length];
        for (int i = 0; i < comparators.length; ++i) {
            Comparator comparator = comparators[i];
            this.hashers[i] = comparator instanceof Hasher ? (Hasher)((Object)comparator) : defaultHasher;
        }
    }

    public final int hashCode(Tuple tuple) {
        int hash2 = 1;
        List<Object> elements = Tuple.elements(tuple);
        for (int i = 0; i < elements.size(); ++i) {
            Object element = elements.get(i);
            hash2 = 31 * hash2 + (element != null ? this.hashers[i % this.hashers.length].hashCode(element) : 0);
        }
        return hash2;
    }

    public static Tuple wrapTuple(TupleHasher tupleHasher, Tuple input2) {
        if (tupleHasher == null) {
            return input2;
        }
        return new WrappedTuple(tupleHasher, input2);
    }

    static class WrappedTuple
    extends Tuple {
        private final TupleHasher tupleHasher;

        public WrappedTuple(TupleHasher tupleHasher, Tuple input2) {
            super(Tuple.elements(input2));
            this.tupleHasher = tupleHasher;
        }

        @Override
        public int hashCode() {
            return this.tupleHasher.hashCode(this);
        }
    }

    private static class ObjectHasher
    implements Hasher<Object> {
        private ObjectHasher() {
        }

        @Override
        public int hashCode(Object value2) {
            return value2.hashCode();
        }
    }
}

