/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.util;

import cascading.tuple.util.Resettable;
import java.util.AbstractList;
import java.util.Arrays;

class ObjectArrayList
extends AbstractList<Object>
implements Resettable<Object> {
    Object[] array;

    ObjectArrayList() {
        this.array = new Object[0];
    }

    ObjectArrayList(Object[] array2) {
        this.array = array2;
    }

    @Override
    public Object get(int index2) {
        if (index2 >= this.array.length) {
            throw new IllegalArgumentException("invalid index: " + index2 + ", length: " + this.array.length);
        }
        return this.array[index2];
    }

    @Override
    public Object set(int index2, Object element) {
        if (index2 >= this.array.length) {
            throw new IllegalArgumentException("invalid index: " + index2 + ", length: " + this.array.length);
        }
        this.array[index2] = element;
        return this.array[index2];
    }

    @Override
    public Object[] toArray() {
        Object[] result2 = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result2[i] = this.get(i);
        }
        return result2;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public void reset(Object ... values2) {
        this.array = values2;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectArrayList");
        sb.append("{array=").append(this.array == null ? "null" : Arrays.asList(this.array).toString());
        sb.append('}');
        return sb.toString();
    }
}

