/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.util;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.util.Resettable;
import java.util.AbstractList;
import java.util.Arrays;

class CompositeTupleList
extends AbstractList<Object>
implements Resettable<Tuple> {
    private int[][] basePos;
    private Tuple[] bases;
    private int[] skip;
    private int length;

    private static int[][] makePos(Tuple[] bases2) {
        int[][] pos = new int[bases2.length][];
        for (int i = 0; i < bases2.length; ++i) {
            Tuple base = bases2[i];
            pos[i] = Fields.size(base.size()).getPos();
        }
        return pos;
    }

    private static int[][] makePos(Fields[] fields2) {
        int[][] pos = new int[fields2.length][];
        for (int i = 0; i < fields2.length; ++i) {
            pos[i] = fields2[i].getPos();
        }
        return pos;
    }

    public CompositeTupleList(Fields ... fields2) {
        this(CompositeTupleList.makePos(fields2), new Tuple[fields2.length]);
    }

    public CompositeTupleList(int[] ... basePos) {
        this(basePos, new Tuple[basePos.length]);
    }

    public CompositeTupleList(Tuple ... bases2) {
        this(CompositeTupleList.makePos(bases2), bases2);
    }

    public CompositeTupleList(Fields[] fields2, Tuple[] bases2) {
        this(CompositeTupleList.makePos(fields2), bases2);
    }

    protected CompositeTupleList(Fields fields2, Tuple base) {
        this((int[][])new int[][]{fields2.getPos()}, new Tuple[]{base});
    }

    protected CompositeTupleList(int[] basePos, Tuple base) {
        this((int[][])new int[][]{basePos}, new Tuple[]{base});
    }

    public CompositeTupleList(int[][] basePos, Tuple[] bases2) {
        this.basePos = basePos;
        this.bases = bases2;
        this.skip = new int[basePos.length + 1];
        for (int i = 0; i < basePos.length; ++i) {
            this.skip[i + 1] = this.skip[i] + basePos[i].length;
            this.length += basePos[i].length;
        }
    }

    public void reset(Tuple ... bases2) {
        if (this.basePos.length != bases2.length) {
            throw new IllegalArgumentException("bases is wrong length, expects: " + this.basePos.length + ", got: " + bases2.length);
        }
        this.bases = bases2;
    }

    @Override
    public Object get(int index2) {
        for (int i = 0; i < this.basePos.length; ++i) {
            if (index2 >= this.skip[i + 1]) continue;
            return this.bases[i].getObject(this.basePos[i][index2 - this.skip[i]]);
        }
        throw new IllegalArgumentException("invalid index: " + index2 + ", length: " + this.basePos.length);
    }

    @Override
    public Object[] toArray() {
        Object[] result2 = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result2[i] = this.get(i);
        }
        return result2;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompositeTupleList");
        sb.append("{basePos=").append(this.basePos == null ? "null" : Arrays.asList(this.basePos).toString());
        sb.append(", bases=").append(this.bases == null ? "null" : Arrays.asList(this.bases).toString());
        sb.append(", skip=").append(this.skip == null ? "null" : "");
        for (int i = 0; this.skip != null && i < this.skip.length; ++i) {
            sb.append(i == 0 ? "" : ", ").append(this.skip[i]);
        }
        sb.append(", length=").append(this.length);
        sb.append('}');
        return sb.toString();
    }
}

