/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.type;

import cascading.CascadingException;
import cascading.tuple.type.CoercibleType;
import cascading.util.Util;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateType
implements CoercibleType<Long> {
    protected TimeZone zone;
    protected Locale locale;
    protected String dateFormatString;
    private transient SimpleDateFormat dateFormat;

    public DateType(String dateFormatString, TimeZone zone, Locale locale) {
        this.zone = zone;
        this.locale = locale;
        this.dateFormatString = dateFormatString;
    }

    public DateType(String dateFormatString, TimeZone zone) {
        this.zone = zone;
        this.dateFormatString = dateFormatString;
    }

    public DateType(String dateFormatString) {
        this.dateFormatString = dateFormatString;
    }

    @Override
    public Class getCanonicalType() {
        return Long.TYPE;
    }

    public SimpleDateFormat getDateFormat() {
        if (this.dateFormat != null) {
            return this.dateFormat;
        }
        this.dateFormat = new SimpleDateFormat(this.dateFormatString, this.getLocale());
        this.dateFormat.setTimeZone(this.getZone());
        return this.dateFormat;
    }

    private Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return Locale.getDefault();
    }

    private TimeZone getZone() {
        if (this.zone != null) {
            return this.zone;
        }
        return TimeZone.getTimeZone("UTC");
    }

    protected Calendar getCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("UTC"), this.getLocale());
    }

    @Override
    public Long canonical(Object value2) {
        if (value2 == null) {
            return null;
        }
        Class<?> from2 = value2.getClass();
        if (from2 == String.class) {
            return this.parse((String)value2).getTime();
        }
        if (from2 == Date.class) {
            return ((Date)value2).getTime();
        }
        if (from2 == Long.class || from2 == Long.TYPE) {
            return (Long)value2;
        }
        throw new CascadingException("unknown type coercion requested from: " + Util.getTypeName(from2));
    }

    @Override
    public Object coerce(Object value2, Type to2) {
        if (value2 == null) {
            return null;
        }
        Class<?> from2 = value2.getClass();
        if (from2 != Long.class) {
            throw new IllegalStateException("was not normalized");
        }
        if (to2 == Long.class || to2 == Long.TYPE || to2 == Object.class) {
            return value2;
        }
        if (to2 == String.class) {
            Calendar calendar = this.getCalendar();
            calendar.setTimeInMillis((Long)value2);
            return this.getDateFormat().format(calendar.getTime());
        }
        throw new CascadingException("unknown type coercion requested, from: " + Util.getTypeName(from2) + " to: " + Util.getTypeName(to2));
    }

    private Date parse(String value2) {
        try {
            return this.getDateFormat().parse(value2);
        }
        catch (ParseException exception) {
            throw new CascadingException("unable to parse value: " + value2 + " with format: " + this.dateFormatString);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DateType{");
        sb.append("dateFormatString='").append(this.dateFormatString).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

