/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.io;

import cascading.tuple.Tuple;
import cascading.tuple.io.IndexTuple;
import cascading.tuple.io.TuplePair;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TupleInputStream
extends DataInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(TupleInputStream.class);
    protected final InputStream inputStream;
    protected final ElementReader elementReader;

    public TupleInputStream(InputStream inputStream, ElementReader elementReader) {
        super(inputStream);
        this.inputStream = inputStream;
        this.elementReader = elementReader;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Tuple readTuple() throws IOException {
        return this.readTuple(new Tuple());
    }

    public Tuple readTuple(Tuple tuple) throws IOException {
        List<Object> elements = Tuple.elements(tuple);
        elements.clear();
        int len = this.getNumElements();
        for (int i = 0; i < len; ++i) {
            elements.add(this.getNextElement());
        }
        return tuple;
    }

    public abstract int getNumElements() throws IOException;

    public abstract int readToken() throws IOException;

    public abstract Object getNextElement() throws IOException;

    public TuplePair readTuplePair() throws IOException {
        return this.readTuplePair(new TuplePair());
    }

    public TuplePair readTuplePair(TuplePair tuplePair) throws IOException {
        Tuple[] tuples = TuplePair.tuples(tuplePair);
        this.readTuple(tuples[0]);
        this.readTuple(tuples[1]);
        return tuplePair;
    }

    public IndexTuple readIndexTuple() throws IOException {
        return this.readIndexTuple(new IndexTuple());
    }

    public abstract IndexTuple readIndexTuple(IndexTuple var1) throws IOException;

    protected abstract Object readType(int var1) throws IOException;

    public Comparator getComparatorFor(int type) throws IOException {
        if (type >= 0 && type <= 10) {
            return null;
        }
        return this.elementReader.getComparatorFor(type, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        LOG.debug("closing tuple input stream");
        try {
            super.close();
        }
        finally {
            if (this.elementReader != null) {
                this.elementReader.close();
            }
        }
    }

    public static interface ElementReader {
        public Object read(int var1, DataInputStream var2) throws IOException;

        public Comparator getComparatorFor(int var1, DataInputStream var2) throws IOException;

        public void close();
    }
}

