/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.util;

import cascading.CascadingException;
import cascading.tuple.StreamComparator;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import java.io.InputStream;
import java.util.Comparator;

public class TupleElementStreamComparator
implements StreamComparator<HadoopTupleInputStream>,
Comparator<Object> {
    final StreamComparator comparator;

    public TupleElementStreamComparator(StreamComparator comparator) {
        this.comparator = comparator;
    }

    @Override
    public int compare(Object lhs, Object rhs) {
        return ((Comparator)((Object)this.comparator)).compare(lhs, rhs);
    }

    @Override
    public int compare(HadoopTupleInputStream lhsStream, HadoopTupleInputStream rhsStream) {
        try {
            int lhsToken = lhsStream.readToken();
            int rhsToken = rhsStream.readToken();
            if (lhsToken == 32) {
                lhsStream.readString();
            }
            if (rhsToken == 32) {
                rhsStream.readString();
            }
            InputStream lhs = lhsToken == 0 ? null : lhsStream.getInputStream();
            InputStream rhs = rhsToken == 0 ? null : rhsStream.getInputStream();
            return this.comparator.compare(lhs, rhs);
        }
        catch (Exception exception) {
            throw new CascadingException("unable to compare Tuples, likely a CoGroup is being attempted on fields of different types or custom comparators are incorrectly set on Fields", exception);
        }
    }
}

