/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.util;

import cascading.CascadingException;
import cascading.tuple.StreamComparator;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.util.TupleElementComparator;
import cascading.tuple.hadoop.util.TupleElementStreamComparator;
import cascading.tuple.io.TupleInputStream;
import java.io.IOException;
import java.util.Comparator;

public class DelegatingTupleElementComparator
implements StreamComparator<TupleInputStream>,
Comparator<Object> {
    final TupleSerialization tupleSerialization;
    Comparator<Object> objectComparator = null;
    StreamComparator<TupleInputStream> streamComparator = null;

    public DelegatingTupleElementComparator(TupleSerialization tupleSerialization) {
        this.tupleSerialization = tupleSerialization;
    }

    @Override
    public int compare(Object lhs, Object rhs) {
        if (this.objectComparator == null) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            this.objectComparator = this.getComparator(lhs, rhs);
        }
        return this.objectComparator.compare(lhs, rhs);
    }

    private Comparator<Object> getComparator(Object lhs, Object rhs) {
        Class<?> type = lhs != null ? lhs.getClass() : null;
        type = type == null && rhs != null ? rhs.getClass() : type;
        return new TupleElementComparator(this.tupleSerialization.getComparator(type));
    }

    @Override
    public int compare(TupleInputStream lhsStream, TupleInputStream rhsStream) {
        if (this.streamComparator == null) {
            this.streamComparator = this.getComparator(lhsStream);
        }
        return this.streamComparator.compare(lhsStream, rhsStream);
    }

    private StreamComparator getComparator(TupleInputStream lhsStream) {
        try {
            lhsStream.mark(4096);
            Comparator foundComparator = lhsStream.getComparatorFor(lhsStream.readToken());
            if (foundComparator == null) {
                foundComparator = this.tupleSerialization.getDefaultComparator();
            }
            if (foundComparator instanceof StreamComparator) {
                TupleElementStreamComparator tupleElementStreamComparator = new TupleElementStreamComparator((StreamComparator)((Object)foundComparator));
                return tupleElementStreamComparator;
            }
            TupleElementComparator tupleElementComparator = new TupleElementComparator(foundComparator);
            return tupleElementComparator;
        }
        catch (IOException exception) {
            throw new CascadingException(exception);
        }
        finally {
            try {
                lhsStream.reset();
            }
            catch (IOException exception) {
                throw new CascadingException(exception);
            }
        }
    }
}

