/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.util;

import cascading.tuple.Hasher;
import cascading.tuple.StreamComparator;
import cascading.tuple.hadoop.io.BufferedInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.io.WritableComparator;

public class BytesComparator
implements StreamComparator<BufferedInputStream>,
Hasher<byte[]>,
Comparator<byte[]>,
Serializable {
    @Override
    public int compare(byte[] lhs, byte[] rhs) {
        if (lhs == rhs) {
            return 0;
        }
        return WritableComparator.compareBytes((byte[])lhs, (int)0, (int)lhs.length, (byte[])rhs, (int)0, (int)rhs.length);
    }

    @Override
    public int compare(BufferedInputStream lhsStream, BufferedInputStream rhsStream) {
        byte[] lhs = lhsStream.getBuffer();
        int lhsPos = lhsStream.getPosition();
        int lhsLen = this.readLen(lhs, lhsPos);
        lhsStream.skip(lhsLen + 4);
        byte[] rhs = rhsStream.getBuffer();
        int rhsPos = rhsStream.getPosition();
        int rhsLen = this.readLen(rhs, rhsPos);
        rhsStream.skip(rhsLen + 4);
        return WritableComparator.compareBytes((byte[])lhs, (int)(lhsPos + 4), (int)lhsLen, (byte[])rhs, (int)(rhsPos + 4), (int)rhsLen);
    }

    private int readLen(byte[] buffer2, int off) {
        return ((buffer2[off] & 0xFF) << 24) + ((buffer2[off + 1] & 0xFF) << 16) + ((buffer2[off + 2] & 0xFF) << 8) + (buffer2[off + 3] & 0xFF);
    }

    @Override
    public int hashCode(byte[] value2) {
        return Arrays.hashCode(value2);
    }
}

