/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.io;

import cascading.tuple.Tuple;
import cascading.tuple.io.IndexTuple;
import cascading.tuple.io.TupleOutputStream;
import cascading.tuple.io.TuplePair;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.hadoop.io.WritableUtils;

public class HadoopTupleOutputStream
extends TupleOutputStream {
    public static final int WRITABLE_TOKEN = 32;
    private static final Map<Class, TupleOutputStream.TupleElementWriter> staticTupleElementWriters = new IdentityHashMap<Class, TupleOutputStream.TupleElementWriter>();

    public HadoopTupleOutputStream(OutputStream outputStream, TupleOutputStream.ElementWriter elementWriter) {
        super(staticTupleElementWriters, outputStream, elementWriter);
    }

    @Override
    protected void writeIntInternal(int value2) throws IOException {
        WritableUtils.writeVInt((DataOutput)this, (int)value2);
    }

    @Override
    public void writeIndexTuple(IndexTuple indexTuple) throws IOException {
        this.writeIntInternal(indexTuple.getIndex());
        this.writeTuple(indexTuple.getTuple());
    }

    static {
        staticTupleElementWriters.put(String.class, new TupleOutputStream.TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)1);
                WritableUtils.writeString((DataOutput)stream, (String)((String)element));
            }
        });
        staticTupleElementWriters.put(Float.class, new TupleOutputStream.TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)2);
                stream.writeFloat(((Float)element).floatValue());
            }
        });
        staticTupleElementWriters.put(Double.class, new TupleOutputStream.TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)3);
                stream.writeDouble((Double)element);
            }
        });
        staticTupleElementWriters.put(Integer.class, new TupleOutputStream.TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)4);
                WritableUtils.writeVInt((DataOutput)stream, (int)((Integer)element));
            }
        });
        staticTupleElementWriters.put(Long.class, new TupleOutputStream.TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)5);
                WritableUtils.writeVLong((DataOutput)stream, (long)((Long)element));
            }
        });
        staticTupleElementWriters.put(Boolean.class, new TupleOutputStream.TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)6);
                stream.writeBoolean((Boolean)element);
            }
        });
        staticTupleElementWriters.put(Short.class, new TupleOutputStream.TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)7);
                stream.writeShort(((Short)element).shortValue());
            }
        });
        staticTupleElementWriters.put(Tuple.class, new TupleOutputStream.TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)8);
                stream.writeTuple((Tuple)element);
            }
        });
        staticTupleElementWriters.put(TuplePair.class, new TupleOutputStream.TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)9);
                stream.writeTuplePair((TuplePair)element);
            }
        });
        staticTupleElementWriters.put(IndexTuple.class, new TupleOutputStream.TupleElementWriter(){

            @Override
            public void write(TupleOutputStream stream, Object element) throws IOException {
                WritableUtils.writeVInt((DataOutput)stream, (int)10);
                stream.writeIndexTuple((IndexTuple)element);
            }
        });
    }
}

