/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.io;

import cascading.tuple.io.IndexTuple;
import cascading.tuple.io.TupleInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.WritableUtils;

public class HadoopTupleInputStream
extends TupleInputStream {
    public HadoopTupleInputStream(InputStream inputStream, TupleInputStream.ElementReader elementReader) {
        super(inputStream, elementReader);
    }

    @Override
    public int getNumElements() throws IOException {
        return this.readVInt();
    }

    @Override
    public int readToken() throws IOException {
        return this.readVInt();
    }

    @Override
    public Object getNextElement() throws IOException {
        return this.readType(this.readToken());
    }

    @Override
    public IndexTuple readIndexTuple(IndexTuple indexTuple) throws IOException {
        indexTuple.setIndex(this.readVInt());
        indexTuple.setTuple(this.readTuple());
        return indexTuple;
    }

    public long readVLong() throws IOException {
        return WritableUtils.readVLong((DataInput)this);
    }

    public int readVInt() throws IOException {
        return WritableUtils.readVInt((DataInput)this);
    }

    public String readString() throws IOException {
        return WritableUtils.readString((DataInput)this);
    }

    @Override
    protected final Object readType(int type) throws IOException {
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return this.readString();
            }
            case 2: {
                return Float.valueOf(this.readFloat());
            }
            case 3: {
                return this.readDouble();
            }
            case 4: {
                return this.readVInt();
            }
            case 5: {
                return this.readVLong();
            }
            case 6: {
                return this.readBoolean();
            }
            case 7: {
                return this.readShort();
            }
            case 8: {
                return this.readTuple();
            }
            case 9: {
                return this.readTuplePair();
            }
            case 10: {
                return this.readIndexTuple();
            }
        }
        return this.elementReader.read(type, this);
    }
}

