/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.io;

import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.HadoopTupleOutputStream;
import cascading.tuple.io.TupleOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.serializer.Serializer;

abstract class BaseSerializer<T>
implements Serializer<T> {
    private final TupleSerialization.SerializationElementWriter elementWriter;
    TupleOutputStream outputStream;

    protected BaseSerializer(TupleSerialization.SerializationElementWriter elementWriter) {
        this.elementWriter = elementWriter;
    }

    public void open(OutputStream out) {
        this.outputStream = out instanceof TupleOutputStream ? (TupleOutputStream)out : new HadoopTupleOutputStream(out, this.elementWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        finally {
            this.outputStream = null;
        }
    }
}

