/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.io;

import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import cascading.tuple.io.TupleInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.serializer.Deserializer;

abstract class BaseDeserializer<T>
implements Deserializer<T> {
    TupleInputStream inputStream;
    private final TupleSerialization.SerializationElementReader elementReader;

    protected BaseDeserializer(TupleSerialization.SerializationElementReader elementReader) {
        this.elementReader = elementReader;
    }

    public void open(InputStream in) {
        this.inputStream = in instanceof TupleInputStream ? (TupleInputStream)in : new HadoopTupleInputStream(in, this.elementReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            this.inputStream = null;
        }
    }
}

