/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.collect;

import cascading.flow.FlowProcess;
import cascading.tuple.Tuple;
import cascading.tuple.collect.SpillableTupleList;
import cascading.tuple.collect.SpillableTupleMap;
import cascading.tuple.collect.TupleMapFactory;
import cascading.tuple.hadoop.collect.HadoopSpillableTupleMap;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.mapred.JobConf;

public class HadoopTupleMapFactory
implements TupleMapFactory<JobConf> {
    private int capacity;
    private float loadFactor;
    private int mapThreshold;
    private int listThreshold;

    @Override
    public void initialize(FlowProcess<JobConf> flowProcess) {
        this.capacity = SpillableTupleMap.getMapCapacity(flowProcess, 100000);
        this.loadFactor = SpillableTupleMap.getMapLoadFactor(flowProcess, 0.75f);
        this.mapThreshold = SpillableTupleMap.getMapThreshold(flowProcess, 10000);
        this.listThreshold = SpillableTupleList.getThreshold(flowProcess, 10000);
    }

    @Override
    public Map<Tuple, Collection<Tuple>> create(FlowProcess<JobConf> flowProcess) {
        return new HadoopSpillableTupleMap(this.capacity, this.loadFactor, this.mapThreshold, this.listThreshold, flowProcess);
    }
}

