/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.collect;

import cascading.flow.FlowProcess;
import cascading.tuple.Tuple;
import cascading.tuple.collect.SpillableTupleList;
import cascading.tuple.collect.TupleCollectionFactory;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.collect.HadoopSpillableTupleList;
import java.util.Collection;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.JobConf;

public class HadoopTupleCollectionFactory
implements TupleCollectionFactory<JobConf> {
    private int spillThreshold;
    private CompressionCodec codec;
    private TupleSerialization tupleSerialization;

    @Override
    public void initialize(FlowProcess<JobConf> flowProcess) {
        this.spillThreshold = SpillableTupleList.getThreshold(flowProcess, 10000);
        this.codec = HadoopSpillableTupleList.getCodec(flowProcess, "org.apache.hadoop.io.compress.GzipCodec,org.apache.hadoop.io.compress.DefaultCodec");
        this.tupleSerialization = new TupleSerialization(flowProcess);
    }

    @Override
    public Collection<Tuple> create(FlowProcess<JobConf> flowProcess) {
        return new HadoopSpillableTupleList(this.spillThreshold, this.tupleSerialization, this.codec);
    }
}

