/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.collect;

import cascading.flow.FlowProcess;
import cascading.provider.FactoryLoader;
import cascading.tuple.Tuple;
import cascading.tuple.collect.Spillable;
import cascading.tuple.collect.SpillableTupleMap;
import cascading.tuple.collect.TupleCollectionFactory;
import cascading.tuple.hadoop.collect.HadoopTupleCollectionFactory;
import java.util.Collection;
import org.apache.hadoop.mapred.JobConf;

public class HadoopSpillableTupleMap
extends SpillableTupleMap {
    private final FlowProcess<JobConf> flowProcess;
    private final Spillable.SpillStrategy spillStrategy;
    private final TupleCollectionFactory<JobConf> tupleCollectionFactory;

    public HadoopSpillableTupleMap(int initialCapacity, float loadFactor, int mapThreshold, int listThreshold, FlowProcess<JobConf> flowProcess) {
        super(initialCapacity, loadFactor, mapThreshold, listThreshold);
        this.flowProcess = flowProcess;
        this.spillStrategy = this.getSpillStrategy();
        FactoryLoader loader = FactoryLoader.getInstance();
        this.tupleCollectionFactory = loader.loadFactoryFrom(flowProcess, "cascading.factory.tuple.map.classname", HadoopTupleCollectionFactory.class);
    }

    @Override
    protected Collection<Tuple> createTupleCollection(Tuple tuple) {
        Collection collection2 = (Collection)this.tupleCollectionFactory.create(this.flowProcess);
        if (collection2 instanceof Spillable) {
            ((Spillable)((Object)collection2)).setGrouping(tuple);
            ((Spillable)((Object)collection2)).setSpillListener(this.getSpillListener());
            ((Spillable)((Object)collection2)).setSpillStrategy(this.spillStrategy);
        }
        return collection2;
    }

    protected Spillable.SpillStrategy getSpillStrategy() {
        return new Spillable.SpillStrategy(){
            int minThreshold;
            {
                this.minThreshold = (int)((double)HadoopSpillableTupleMap.this.getMapThreshold() * 0.05);
            }

            int current() {
                return Math.max(this.minThreshold, Math.min(HadoopSpillableTupleMap.this.getInitListThreshold(), HadoopSpillableTupleMap.this.getMapThreshold() / HadoopSpillableTupleMap.this.size()));
            }

            @Override
            public boolean doSpill(Spillable spillable, int size2) {
                return this.current() <= size2;
            }

            @Override
            public String getSpillReason(Spillable spillable) {
                return "met current threshold: " + this.current();
            }
        };
    }
}

