/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop.collect;

import cascading.flow.FlowProcess;
import cascading.flow.FlowProcessWrapper;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.tuple.TupleException;
import cascading.tuple.collect.SpillableTupleList;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.io.HadoopTupleInputStream;
import cascading.tuple.hadoop.io.HadoopTupleOutputStream;
import cascading.tuple.io.TupleInputStream;
import cascading.tuple.io.TupleOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopSpillableTupleList
extends SpillableTupleList {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopSpillableTupleList.class);
    public static final String defaultCodecs = "org.apache.hadoop.io.compress.GzipCodec,org.apache.hadoop.io.compress.DefaultCodec";
    private final CompressionCodec codec;
    private final TupleSerialization tupleSerialization;

    public static synchronized CompressionCodec getCodec(FlowProcess flowProcess, String defaultCodecs) {
        Class codecClass = HadoopSpillableTupleList.getCodecClass(flowProcess, defaultCodecs, CompressionCodec.class);
        if (codecClass == null) {
            return null;
        }
        if (flowProcess instanceof FlowProcessWrapper) {
            flowProcess = ((FlowProcessWrapper)flowProcess).getDelegate();
        }
        return (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)((HadoopFlowProcess)flowProcess).getJobConf());
    }

    public HadoopSpillableTupleList(int threshold, CompressionCodec codec, JobConf jobConf) {
        super(threshold);
        this.codec = codec;
        this.tupleSerialization = jobConf == null ? new TupleSerialization() : new TupleSerialization((Configuration)jobConf);
    }

    public HadoopSpillableTupleList(int threshold, TupleSerialization tupleSerialization, CompressionCodec codec) {
        super(threshold);
        this.tupleSerialization = tupleSerialization;
        this.codec = codec;
    }

    @Override
    protected TupleOutputStream createTupleOutputStream(File file) {
        try {
            FileOutputStream outputStream = new FileOutputStream(file);
            Compressor compressor = null;
            if (this.codec != null) {
                compressor = this.getCompressor();
                outputStream = this.codec.createOutputStream((OutputStream)outputStream, compressor);
            }
            final Compressor finalCompressor = compressor;
            return new HadoopTupleOutputStream(outputStream, this.tupleSerialization.getElementWriter()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        if (finalCompressor != null) {
                            CodecPool.returnCompressor((Compressor)finalCompressor);
                        }
                    }
                }
            };
        }
        catch (IOException exception) {
            throw new TupleException("unable to create temporary file input stream", exception);
        }
    }

    private Compressor getCompressor() {
        try {
            return CodecPool.getCompressor((CompressionCodec)this.codec);
        }
        catch (OutOfMemoryError error2) {
            System.gc();
            LOG.info("received OOME when allocating compressor for codec: {}, retrying once", (Object)this.codec.getClass().getCanonicalName(), (Object)error2);
            return CodecPool.getCompressor((CompressionCodec)this.codec);
        }
    }

    @Override
    protected TupleInputStream createTupleInputStream(File file) {
        try {
            FileInputStream inputStream = new FileInputStream(file);
            Decompressor decompressor = null;
            if (this.codec != null) {
                decompressor = this.getDecompressor();
                inputStream = this.codec.createInputStream((InputStream)inputStream, decompressor);
            }
            final Decompressor finalDecompressor = decompressor;
            return new HadoopTupleInputStream(inputStream, this.tupleSerialization.getElementReader()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        if (finalDecompressor != null) {
                            CodecPool.returnDecompressor((Decompressor)finalDecompressor);
                        }
                    }
                }
            };
        }
        catch (IOException exception) {
            throw new TupleException("unable to create temporary file output stream", exception);
        }
    }

    private Decompressor getDecompressor() {
        try {
            return CodecPool.getDecompressor((CompressionCodec)this.codec);
        }
        catch (OutOfMemoryError error2) {
            System.gc();
            LOG.info("received OOME when allocating decompressor for codec: {}, retrying once", (Object)this.codec.getClass().getCanonicalName(), (Object)error2);
            return CodecPool.getDecompressor((CompressionCodec)this.codec);
        }
    }
}

