/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.property.Props;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TupleSerializationProps
extends Props {
    public static final String SERIALIZATION_TOKENS = "cascading.serialization.tokens";
    public static final String HADOOP_IO_SERIALIZATIONS = "io.serializations";
    Map<Integer, String> serializationTokens = new LinkedHashMap<Integer, String>();
    List<String> hadoopSerializations = new ArrayList<String>();

    public static void addSerializationToken(Map<Object, Object> properties, int token2, String className) {
        String tokens = TupleSerializationProps.getSerializationTokens(properties);
        properties.put(SERIALIZATION_TOKENS, Util.join(",", Util.removeNulls(tokens, token2 + "=" + className)));
    }

    public static String getSerializationTokens(Map<Object, Object> properties) {
        return (String)properties.get(SERIALIZATION_TOKENS);
    }

    public static void addSerialization(Map<Object, Object> properties, String className) {
        String serializations = (String)properties.get(HADOOP_IO_SERIALIZATIONS);
        properties.put(HADOOP_IO_SERIALIZATIONS, Util.join(",", Util.removeNulls(serializations, className)));
    }

    public static TupleSerializationProps tupleSerializationProps() {
        return new TupleSerializationProps();
    }

    public Map<Integer, String> getSerializationTokens() {
        return this.serializationTokens;
    }

    public TupleSerializationProps setSerializationTokens(Map<Integer, String> serializationTokens) {
        this.serializationTokens = serializationTokens;
        return this;
    }

    public TupleSerializationProps addSerializationTokens(Map<Integer, String> serializationTokens) {
        this.serializationTokens.putAll(serializationTokens);
        return this;
    }

    public TupleSerializationProps addSerializationToken(int token2, String serializationClassName) {
        this.serializationTokens.put(token2, serializationClassName);
        return this;
    }

    public List<String> getHadoopSerializations() {
        return this.hadoopSerializations;
    }

    public TupleSerializationProps setHadoopSerializations(List<String> hadoopSerializationClassNames) {
        this.hadoopSerializations = hadoopSerializationClassNames;
        return this;
    }

    public TupleSerializationProps addHadoopSerializations(List<String> hadoopSerializationClassNames) {
        this.hadoopSerializations.addAll(hadoopSerializationClassNames);
        return this;
    }

    public TupleSerializationProps addHadoopSerialization(String hadoopSerializationClassName) {
        this.hadoopSerializations.add(hadoopSerializationClassName);
        return this;
    }

    @Override
    protected void addPropertiesTo(Properties properties) {
        for (Map.Entry<Integer, String> entry2 : this.serializationTokens.entrySet()) {
            TupleSerializationProps.addSerializationToken(properties, entry2.getKey(), entry2.getValue());
        }
        for (String hadoopSerialization : this.hadoopSerializations) {
            TupleSerializationProps.addSerialization(properties, hadoopSerialization);
        }
    }
}

