/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.tuple.Comparison;
import cascading.tuple.Tuple;
import cascading.tuple.TupleException;
import cascading.tuple.hadoop.SerializationToken;
import cascading.tuple.hadoop.TupleSerializationProps;
import cascading.tuple.hadoop.io.IndexTupleDeserializer;
import cascading.tuple.hadoop.io.IndexTupleSerializer;
import cascading.tuple.hadoop.io.TupleDeserializer;
import cascading.tuple.hadoop.io.TuplePairDeserializer;
import cascading.tuple.hadoop.io.TuplePairSerializer;
import cascading.tuple.hadoop.io.TupleSerializer;
import cascading.tuple.io.IndexTuple;
import cascading.tuple.io.TupleInputStream;
import cascading.tuple.io.TupleOutputStream;
import cascading.tuple.io.TuplePair;
import cascading.util.Util;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.io.serializer.WritableSerialization;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerializationToken(tokens={127}, classNames={"org.apache.hadoop.io.BytesWritable"})
public class TupleSerialization
extends Configured
implements Serialization {
    private static final Logger LOG = LoggerFactory.getLogger(TupleSerialization.class);
    private Comparator defaultComparator;
    private final Map<String, Class> classCache = new HashMap<String, Class>();
    private SerializationFactory serializationFactory;
    private HashMap<Integer, String> tokenClassesMap;
    private HashMap<String, Integer> classesTokensMap;
    private long tokensSize = 0L;

    @Deprecated
    public static void addSerializationToken(Map<Object, Object> properties, int token2, String className) {
        TupleSerializationProps.addSerializationToken(properties, token2, className);
    }

    @Deprecated
    public static String getSerializationTokens(Map<Object, Object> properties) {
        return TupleSerializationProps.getSerializationTokens(properties);
    }

    static String getSerializationTokens(Configuration jobConf) {
        return jobConf.get("cascading.serialization.tokens");
    }

    @Deprecated
    public static void addSerialization(Map<Object, Object> properties, String className) {
        TupleSerializationProps.addSerialization(properties, className);
    }

    public static void setSerializations(JobConf jobConf) {
        String serializations = TupleSerialization.getSerializations((Configuration)jobConf);
        LinkedList<String> list2 = new LinkedList<String>();
        if (serializations != null && !serializations.isEmpty()) {
            Collections.addAll(list2, serializations.split(","));
        }
        String writable = WritableSerialization.class.getName();
        String tuple = TupleSerialization.class.getName();
        list2.remove(writable);
        list2.remove(tuple);
        list2.addFirst(writable);
        list2.addFirst(tuple);
        jobConf.set("io.serializations", Util.join(list2, ","));
    }

    static String getSerializations(Configuration jobConf) {
        return jobConf.get("io.serializations", null);
    }

    public static Comparator getDefaultComparator(Comparator comparator, Configuration jobConf) {
        String typeName = jobConf.get("cascading.flow.tuple.element.comparator");
        if (Util.isEmpty(typeName)) {
            return null;
        }
        if (comparator == null) {
            return TupleSerialization.createComparator(jobConf, typeName);
        }
        if (comparator.getClass().getName().equals(typeName) && !(comparator instanceof Configured)) {
            return comparator;
        }
        return TupleSerialization.createComparator(jobConf, typeName);
    }

    public static Comparator getDefaultComparator(Configuration jobConf) {
        String typeName = jobConf.get("cascading.flow.tuple.element.comparator");
        if (Util.isEmpty(typeName)) {
            return null;
        }
        return TupleSerialization.createComparator(jobConf, typeName);
    }

    private static Comparator createComparator(Configuration jobConf, String typeName) {
        LOG.debug("using default comparator: {}", (Object)typeName);
        try {
            Class<?> type = TupleSerialization.class.getClassLoader().loadClass(typeName);
            return (Comparator)ReflectionUtils.newInstance(type, (Configuration)jobConf);
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + typeName, exception);
        }
    }

    public TupleSerialization() {
    }

    public TupleSerialization(final FlowProcess<JobConf> flowProcess) {
        super(new Configuration(){

            public String get(String name2) {
                return this.get(name2, null);
            }

            public String get(String name2, String defaultValue2) {
                Object value2 = flowProcess.getProperty(name2);
                return value2 == null ? defaultValue2 : String.valueOf(value2);
            }
        });
    }

    public TupleSerialization(Configuration conf) {
        super(conf);
    }

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf != null) {
            this.defaultComparator = TupleSerialization.getDefaultComparator(conf);
        }
    }

    public Configuration getConf() {
        if (super.getConf() == null) {
            this.setConf((Configuration)new JobConf());
        }
        return super.getConf();
    }

    SerializationFactory getSerializationFactory() {
        if (this.serializationFactory == null) {
            this.serializationFactory = new SerializationFactory(this.getConf());
        }
        return this.serializationFactory;
    }

    void initTokenMaps() {
        String[] serializations;
        if (this.tokenClassesMap != null) {
            return;
        }
        this.tokenClassesMap = new HashMap();
        this.classesTokensMap = new HashMap();
        String tokenProperty = TupleSerialization.getSerializationTokens(this.getConf());
        if (tokenProperty != null) {
            tokenProperty = tokenProperty.replaceAll("\\s", "");
            for (String pair2 : tokenProperty.split(",")) {
                String[] elements = pair2.split("=");
                this.addToken(null, Integer.parseInt(elements[0]), elements[1]);
            }
        }
        String serializationsString = TupleSerialization.getSerializations(this.getConf());
        LOG.debug("using hadoop serializations from the job conf: {} ", (Object)serializationsString);
        if (serializationsString == null) {
            return;
        }
        for (String serializationName : serializations = serializationsString.split(",")) {
            try {
                Class type = this.getConf().getClassByName(serializationName);
                SerializationToken tokenAnnotation = type.getAnnotation(SerializationToken.class);
                if (tokenAnnotation == null) continue;
                if (tokenAnnotation.tokens().length != tokenAnnotation.classNames().length) {
                    throw new CascadingException("serialization annotation tokens and classNames must be the same length");
                }
                int[] tokens = tokenAnnotation.tokens();
                for (int i = 0; i < tokens.length; ++i) {
                    this.addToken(type, tokens[i], tokenAnnotation.classNames()[i]);
                }
            }
            catch (ClassNotFoundException exception) {
                LOG.warn("unable to load serialization class: {}", (Object)serializationName, (Object)exception);
            }
        }
        this.tokensSize = this.tokenClassesMap.size();
    }

    private void addToken(Class type, int token2, String className) {
        if (type != null && !type.getName().startsWith("cascading.") && token2 < 128) {
            throw new CascadingException("serialization annotation tokens may not be less than 128, was: " + token2);
        }
        if (this.tokenClassesMap.containsKey(token2)) {
            if (type == null) {
                throw new IllegalStateException("duplicate serialization token: " + token2 + " for class: " + className + " found in properties");
            }
            throw new IllegalStateException("duplicate serialization token: " + token2 + " for class: " + className + " on serialization: " + type.getName());
        }
        if (this.classesTokensMap.containsKey(className)) {
            if (type == null) {
                throw new IllegalStateException("duplicate serialization classname: " + className + " for token: " + token2 + " found in properties ");
            }
            throw new IllegalStateException("duplicate serialization classname: " + className + " for token: " + token2 + " on serialization: " + type.getName());
        }
        LOG.debug("adding serialization token: {}, for classname: {}", (Object)token2, (Object)className);
        this.tokenClassesMap.put(token2, className);
        this.classesTokensMap.put(className, token2);
    }

    final String getClassNameFor(int token2) {
        if (this.tokensSize == 0L) {
            return null;
        }
        return this.tokenClassesMap.get(token2);
    }

    final long getTokensMapSize() {
        return this.tokensSize;
    }

    final Integer getTokenFor(String className) {
        if (this.tokensSize == 0L) {
            return null;
        }
        return this.classesTokensMap.get(className);
    }

    public Comparator getDefaultComparator() {
        return this.defaultComparator;
    }

    public Comparator getComparator(Class type) {
        Serialization serialization = this.getSerialization(type);
        Comparator comparator = null;
        if (serialization instanceof Comparison) {
            comparator = ((Comparison)serialization).getComparator(type);
        }
        if (comparator != null) {
            return comparator;
        }
        return this.defaultComparator;
    }

    Serialization getSerialization(String className) {
        return this.getSerialization(this.getClass(className));
    }

    Serialization getSerialization(Class type) {
        return this.getSerializationFactory().getSerialization(type);
    }

    Serializer getNewSerializer(Class type) {
        try {
            Serializer serializer = this.getSerializationFactory().getSerializer(type);
            if (serializer == null) {
                throw new CascadingException("unable to load serializer for: " + type.getName() + " from: " + this.getSerializationFactory().getClass().getName());
            }
            return serializer;
        }
        catch (NullPointerException exception) {
            throw new CascadingException("unable to load serializer for: " + type.getName() + " from: " + this.getSerializationFactory().getClass().getName());
        }
    }

    Deserializer getNewDeserializer(String className) {
        try {
            Deserializer deserializer = this.getSerializationFactory().getDeserializer(this.getClass(className));
            if (deserializer == null) {
                throw new CascadingException("unable to load deserializer for: " + className + " from: " + this.getSerializationFactory().getClass().getName());
            }
            return deserializer;
        }
        catch (NullPointerException exception) {
            throw new CascadingException("unable to load deserializer for: " + className + " from: " + this.getSerializationFactory().getClass().getName());
        }
    }

    TuplePairDeserializer getTuplePairDeserializer() {
        return new TuplePairDeserializer(this.getElementReader());
    }

    public SerializationElementReader getElementReader() {
        return new SerializationElementReader(this);
    }

    TupleDeserializer getTupleDeserializer() {
        return new TupleDeserializer(this.getElementReader());
    }

    private TuplePairSerializer getTuplePairSerializer() {
        return new TuplePairSerializer(this.getElementWriter());
    }

    IndexTupleDeserializer getIndexTupleDeserializer() {
        return new IndexTupleDeserializer(this.getElementReader());
    }

    public SerializationElementWriter getElementWriter() {
        return new SerializationElementWriter(this);
    }

    private TupleSerializer getTupleSerializer() {
        return new TupleSerializer(this.getElementWriter());
    }

    private IndexTupleSerializer getIndexTupleSerializer() {
        return new IndexTupleSerializer(this.getElementWriter());
    }

    public boolean accept(Class c) {
        return Tuple.class == c || TuplePair.class == c || IndexTuple.class == c;
    }

    public Deserializer getDeserializer(Class c) {
        if (c == Tuple.class) {
            return this.getTupleDeserializer();
        }
        if (c == TuplePair.class) {
            return this.getTuplePairDeserializer();
        }
        if (c == IndexTuple.class) {
            return this.getIndexTupleDeserializer();
        }
        throw new IllegalArgumentException("unknown class, cannot deserialize: " + c.getName());
    }

    public Serializer getSerializer(Class c) {
        if (c == Tuple.class) {
            return this.getTupleSerializer();
        }
        if (c == TuplePair.class) {
            return this.getTuplePairSerializer();
        }
        if (c == IndexTuple.class) {
            return this.getIndexTupleSerializer();
        }
        throw new IllegalArgumentException("unknown class, cannot serialize: " + c.getName());
    }

    public Class getClass(String className) {
        Class<?> type = this.classCache.get(className);
        if (type != null) {
            return type;
        }
        try {
            type = className.charAt(0) == '[' ? Class.forName(className, true, Thread.currentThread().getContextClassLoader()) : Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException exception) {
            throw new TupleException("unable to load class named: " + className, exception);
        }
        this.classCache.put(className, type);
        return type;
    }

    public static class SerializationElementWriter
    implements TupleOutputStream.ElementWriter {
        private static final Logger LOG = LoggerFactory.getLogger(SerializationElementWriter.class);
        private final TupleSerialization tupleSerialization;
        final Map<Class, Serializer> serializers = new HashMap<Class, Serializer>();

        public SerializationElementWriter(TupleSerialization tupleSerialization) {
            this.tupleSerialization = tupleSerialization;
            tupleSerialization.initTokenMaps();
        }

        @Override
        public void write(DataOutputStream outputStream, Object object) throws IOException {
            Class<?> type = object.getClass();
            String className = type.getName();
            Integer token2 = this.tupleSerialization.getTokenFor(className);
            if (token2 == null) {
                LOG.debug("no serialization token found for classname: {}", (Object)className);
                WritableUtils.writeVInt((DataOutput)outputStream, (int)32);
                WritableUtils.writeString((DataOutput)outputStream, (String)className);
            } else {
                WritableUtils.writeVInt((DataOutput)outputStream, (int)token2);
            }
            Serializer serializer = this.serializers.get(type);
            if (serializer == null) {
                serializer = this.tupleSerialization.getNewSerializer(type);
                serializer.open((OutputStream)outputStream);
                this.serializers.put(type, serializer);
            }
            try {
                serializer.serialize(object);
            }
            catch (IOException exception) {
                LOG.error("failed serializing token: " + token2 + " with classname: " + className, exception);
                throw exception;
            }
        }

        @Override
        public void close() {
            if (this.serializers.size() == 0) {
                return;
            }
            ArrayList<Serializer> clone2 = new ArrayList<Serializer>(this.serializers.values());
            this.serializers.clear();
            for (Serializer serializer : clone2) {
                try {
                    serializer.close();
                }
                catch (IOException exception) {}
            }
        }
    }

    public static class SerializationElementReader
    implements TupleInputStream.ElementReader {
        private static final Logger LOG = LoggerFactory.getLogger(SerializationElementReader.class);
        private final TupleSerialization tupleSerialization;
        final Map<String, Deserializer> deserializers = new HashMap<String, Deserializer>();

        public SerializationElementReader(TupleSerialization tupleSerialization) {
            this.tupleSerialization = tupleSerialization;
            tupleSerialization.initTokenMaps();
        }

        @Override
        public Object read(int token2, DataInputStream inputStream) throws IOException {
            Object object;
            String className = this.getClassNameFor(token2, inputStream);
            Deserializer deserializer = this.getDeserializerFor(inputStream, className);
            Object foundObject = null;
            try {
                object = deserializer.deserialize(foundObject);
            }
            catch (IOException exception) {
                LOG.error("failed deserializing token: " + token2 + " with classname: " + className, exception);
                throw exception;
            }
            return object;
        }

        @Override
        public Comparator getComparatorFor(int token2, DataInputStream inputStream) throws IOException {
            Class type = this.tupleSerialization.getClass(this.getClassNameFor(token2, inputStream));
            return this.tupleSerialization.getComparator(type);
        }

        private Deserializer getDeserializerFor(DataInputStream inputStream, String className) throws IOException {
            Deserializer deserializer = this.deserializers.get(className);
            if (deserializer == null) {
                deserializer = this.tupleSerialization.getNewDeserializer(className);
                deserializer.open((InputStream)inputStream);
                this.deserializers.put(className, deserializer);
            }
            return deserializer;
        }

        public String getClassNameFor(int token2, DataInputStream inputStream) throws IOException {
            String className = this.tupleSerialization.getClassNameFor(token2);
            try {
                if (className == null) {
                    className = WritableUtils.readString((DataInput)inputStream);
                }
            }
            catch (IOException exception) {
                LOG.error("unable to resolve token: {}, to a valid classname, with token map of size: {}, rethrowing IOException", (Object)token2, (Object)this.tupleSerialization.getTokensMapSize());
                throw exception;
            }
            return className;
        }

        @Override
        public void close() {
            if (this.deserializers.size() == 0) {
                return;
            }
            ArrayList<Deserializer> clone2 = new ArrayList<Deserializer>(this.deserializers.values());
            this.deserializers.clear();
            for (Deserializer deserializer : clone2) {
                try {
                    deserializer.close();
                }
                catch (IOException exception) {}
            }
        }
    }
}

