/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.hadoop;

import cascading.tuple.Comparison;
import cascading.tuple.hadoop.SerializationToken;
import cascading.tuple.hadoop.util.BytesComparator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

@SerializationToken(tokens={126}, classNames={"[B"})
public class BytesSerialization
extends Configured
implements Comparison<byte[]>,
Serialization<byte[]> {
    public boolean accept(Class<?> c) {
        return byte[].class == c;
    }

    public Serializer<byte[]> getSerializer(Class<byte[]> c) {
        return new RawBytesSerializer();
    }

    public Deserializer<byte[]> getDeserializer(Class<byte[]> c) {
        return new RawBytesDeserializer();
    }

    @Override
    public Comparator<byte[]> getComparator(Class<byte[]> type) {
        return new BytesComparator();
    }

    public static class RawBytesSerializer
    implements Serializer<byte[]> {
        private DataOutputStream out;

        public void open(OutputStream out) throws IOException {
            this.out = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        }

        public void serialize(byte[] bytes2) throws IOException {
            this.out.writeInt(bytes2.length);
            this.out.write(bytes2);
        }

        public void close() throws IOException {
            this.out.close();
        }
    }

    public static class RawBytesDeserializer
    implements Deserializer<byte[]> {
        private DataInputStream in;

        public void open(InputStream in) throws IOException {
            this.in = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        }

        public byte[] deserialize(byte[] existing) throws IOException {
            int len = this.in.readInt();
            byte[] bytes2 = existing != null && existing.length == len ? existing : new byte[len];
            this.in.readFully(bytes2);
            return bytes2;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

