/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.collect;

import cascading.flow.FlowProcess;
import cascading.tuple.Tuple;
import cascading.tuple.collect.Spillable;
import java.util.Collection;
import java.util.HashMap;

public abstract class SpillableTupleMap
extends HashMap<Tuple, Collection<Tuple>>
implements Spillable {
    @Deprecated
    public static final String MAP_THRESHOLD = "cascading.spill.map.threshold";
    @Deprecated
    public static final String MAP_CAPACITY = "cascading.spill.map.capacity";
    @Deprecated
    public static final String MAP_LOADFACTOR = "cascading.spill.map.loadfactor";
    private int mapThreshold;
    private int initListThreshold;
    private Spillable.SpillListener spillListener = Spillable.SpillListener.NULL;

    public static int getMapThreshold(FlowProcess flowProcess, int defaultValue2) {
        String value2 = (String)flowProcess.getProperty(MAP_THRESHOLD);
        if (value2 == null || value2.length() == 0) {
            return defaultValue2;
        }
        return Integer.parseInt(value2);
    }

    public static int getMapCapacity(FlowProcess flowProcess, int defaultValue2) {
        String value2 = (String)flowProcess.getProperty(MAP_CAPACITY);
        if (value2 == null || value2.length() == 0) {
            return defaultValue2;
        }
        return Integer.parseInt(value2);
    }

    public static float getMapLoadFactor(FlowProcess flowProcess, float defaultValue2) {
        String value2 = (String)flowProcess.getProperty(MAP_LOADFACTOR);
        if (value2 == null || value2.length() == 0) {
            return defaultValue2;
        }
        return Float.parseFloat(value2);
    }

    public SpillableTupleMap(int mapThreshold, int initListThreshold) {
        super(100000, 0.75f);
        this.mapThreshold = mapThreshold;
        this.initListThreshold = initListThreshold;
    }

    public SpillableTupleMap(int initialCapacity, float loadFactor, int mapThreshold, int initListThreshold) {
        super(initialCapacity, loadFactor);
        this.mapThreshold = mapThreshold;
        this.initListThreshold = initListThreshold;
    }

    protected int getMapThreshold() {
        return this.mapThreshold;
    }

    public int getInitListThreshold() {
        return this.initListThreshold;
    }

    @Override
    public Collection<Tuple> get(Object object) {
        Collection<Tuple> value2 = (Collection<Tuple>)super.get(object);
        if (value2 == null) {
            value2 = this.createTupleCollection((Tuple)object);
            super.put((Tuple)object, value2);
        }
        return value2;
    }

    protected abstract Collection<Tuple> createTupleCollection(Tuple var1);

    @Override
    public void setGrouping(Tuple group2) {
    }

    @Override
    public Tuple getGrouping() {
        return null;
    }

    @Override
    public void setSpillStrategy(Spillable.SpillStrategy spillStrategy) {
    }

    @Override
    public int spillCount() {
        return 0;
    }

    public Spillable.SpillListener getSpillListener() {
        return this.spillListener;
    }

    @Override
    public void setSpillListener(Spillable.SpillListener spillListener) {
        this.spillListener = spillListener;
    }
}

