/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.collect;

import cascading.property.Props;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class SpillableProps
extends Props {
    public static final String SPILL_COMPRESS = "cascading.spill.compress";
    public static final String SPILL_CODECS = "cascading.spill.codecs";
    public static final String LIST_THRESHOLD = "cascading.spill.list.threshold";
    public static final String MAP_THRESHOLD = "cascading.spill.map.threshold";
    public static final String MAP_CAPACITY = "cascading.spill.map.capacity";
    public static final String MAP_LOADFACTOR = "cascading.spill.map.loadfactor";
    public static final int defaultListThreshold = 10000;
    public static final int defaultMapThreshold = 10000;
    public static final int defaultMapInitialCapacity = 100000;
    public static final float defaultMapLoadFactor = 0.75f;
    boolean compressSpill = true;
    List<String> codecs = new ArrayList<String>();
    int listSpillThreshold = 10000;
    int mapSpillThreshold = 10000;
    int mapInitialCapacity = 100000;
    float mapLoadFactor = 0.75f;

    public static SpillableProps spillableProps() {
        return new SpillableProps();
    }

    public boolean isCompressSpill() {
        return this.compressSpill;
    }

    public SpillableProps setCompressSpill(boolean compressSpill) {
        this.compressSpill = compressSpill;
        return this;
    }

    public List<String> getCodecs() {
        return this.codecs;
    }

    public SpillableProps setCodecs(List<String> codecs) {
        this.codecs = codecs;
        return this;
    }

    public SpillableProps addCodecs(List<String> codecs) {
        this.codecs.addAll(codecs);
        return this;
    }

    public SpillableProps addCodec(String codec) {
        this.codecs.add(codec);
        return this;
    }

    public int getListSpillThreshold() {
        return this.listSpillThreshold;
    }

    public SpillableProps setListSpillThreshold(int listSpillThreshold) {
        this.listSpillThreshold = listSpillThreshold;
        return this;
    }

    public int getMapSpillThreshold() {
        return this.mapSpillThreshold;
    }

    public SpillableProps setMapSpillThreshold(int mapSpillThreshold) {
        this.mapSpillThreshold = mapSpillThreshold;
        return this;
    }

    public int getMapInitialCapacity() {
        return this.mapInitialCapacity;
    }

    public SpillableProps setMapInitialCapacity(int mapInitialCapacity) {
        this.mapInitialCapacity = mapInitialCapacity;
        return this;
    }

    public float getMapLoadFactor() {
        return this.mapLoadFactor;
    }

    public SpillableProps setMapLoadFactor(float mapLoadFactor) {
        this.mapLoadFactor = mapLoadFactor;
        return this;
    }

    @Override
    protected void addPropertiesTo(Properties properties) {
        for (String codec : this.codecs) {
            String codecs = (String)properties.get(SPILL_CODECS);
            properties.put(SPILL_CODECS, Util.join(",", Util.removeNulls(codecs, codec)));
        }
        properties.setProperty(SPILL_COMPRESS, Boolean.toString(this.compressSpill));
        properties.setProperty(LIST_THRESHOLD, Integer.toString(this.listSpillThreshold));
        properties.setProperty(MAP_THRESHOLD, Integer.toString(this.mapSpillThreshold));
        properties.setProperty(MAP_CAPACITY, Integer.toString(this.mapInitialCapacity));
        properties.setProperty(MAP_LOADFACTOR, Float.toString(this.mapLoadFactor));
    }
}

