/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.collect;

import cascading.tuple.Tuple;
import cascading.tuple.collect.SpillableTupleList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Spillable {
    public void setGrouping(Tuple var1);

    public Tuple getGrouping();

    public void setSpillStrategy(SpillStrategy var1);

    public void setSpillListener(SpillListener var1);

    public int spillCount();

    public static interface SpillListener {
        public static final SpillListener NULL = new SpillListener(){
            private final Logger LOG = LoggerFactory.getLogger(SpillListener.class);

            @Override
            public void notifyWriteSpillBegin(Spillable spillable, int spillSize, String spillReason) {
                this.LOG.info("spilling {} tuples in list to spill number {}", (Object)spillSize, (Object)(spillable.spillCount() + 1));
            }

            @Override
            public void notifyReadSpillBegin(Spillable spillable) {
            }

            @Override
            public void notifyWriteSpillEnd(SpillableTupleList spillableTupleList, long duration) {
            }
        };

        public void notifyWriteSpillBegin(Spillable var1, int var2, String var3);

        public void notifyWriteSpillEnd(SpillableTupleList var1, long var2);

        public void notifyReadSpillBegin(Spillable var1);
    }

    public static interface SpillStrategy {
        public boolean doSpill(Spillable var1, int var2);

        public String getSpillReason(Spillable var1);
    }
}

