/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple.coerce;

import cascading.cascade.CascadeException;
import cascading.tuple.Fields;
import cascading.tuple.coerce.BigDecimalCoerce;
import cascading.tuple.coerce.BooleanCoerce;
import cascading.tuple.coerce.BooleanObjectCoerce;
import cascading.tuple.coerce.CharacterCoerce;
import cascading.tuple.coerce.CharacterObjectCoerce;
import cascading.tuple.coerce.DoubleCoerce;
import cascading.tuple.coerce.DoubleObjectCoerce;
import cascading.tuple.coerce.FloatCoerce;
import cascading.tuple.coerce.FloatObjectCoerce;
import cascading.tuple.coerce.IntegerCoerce;
import cascading.tuple.coerce.IntegerObjectCoerce;
import cascading.tuple.coerce.LongCoerce;
import cascading.tuple.coerce.LongObjectCoerce;
import cascading.tuple.coerce.ObjectCoerce;
import cascading.tuple.coerce.ShortCoerce;
import cascading.tuple.coerce.ShortObjectCoerce;
import cascading.tuple.coerce.StringCoerce;
import cascading.tuple.type.CoercibleType;
import cascading.util.Util;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public final class Coercions {
    private static final Map<Type, Coerce> coercionsPrivate = new IdentityHashMap<Type, Coerce>();
    public static final Map<Type, Coerce> coercions = Collections.unmodifiableMap(coercionsPrivate);
    private static final Map<String, Type> typesPrivate = new HashMap<String, Type>();
    public static final Map<String, Type> types = Collections.unmodifiableMap(typesPrivate);
    public static final Coerce<Object> OBJECT = new ObjectCoerce(coercionsPrivate);
    public static final Coerce<String> STRING = new StringCoerce(coercionsPrivate);
    public static final Coerce<Character> CHARACTER = new CharacterCoerce(coercionsPrivate);
    public static final Coerce<Character> CHARACTER_OBJECT = new CharacterObjectCoerce(coercionsPrivate);
    public static final Coerce<Short> SHORT = new ShortCoerce(coercionsPrivate);
    public static final Coerce<Short> SHORT_OBJECT = new ShortObjectCoerce(coercionsPrivate);
    public static final Coerce<Integer> INTEGER = new IntegerCoerce(coercionsPrivate);
    public static final Coerce<Integer> INTEGER_OBJECT = new IntegerObjectCoerce(coercionsPrivate);
    public static final Coerce<Double> DOUBLE = new DoubleCoerce(coercionsPrivate);
    public static final Coerce<Double> DOUBLE_OBJECT = new DoubleObjectCoerce(coercionsPrivate);
    public static final Coerce<Long> LONG = new LongCoerce(coercionsPrivate);
    public static final Coerce<Long> LONG_OBJECT = new LongObjectCoerce(coercionsPrivate);
    public static final Coerce<Float> FLOAT = new FloatCoerce(coercionsPrivate);
    public static final Coerce<Float> FLOAT_OBJECT = new FloatObjectCoerce(coercionsPrivate);
    public static final Coerce<Boolean> BOOLEAN = new BooleanCoerce(coercionsPrivate);
    public static final Coerce<Boolean> BOOLEAN_OBJECT = new BooleanObjectCoerce(coercionsPrivate);
    public static final Coerce<BigDecimal> BIG_DECIMAL = new BigDecimalCoerce(coercionsPrivate);
    private static final Map<Class, Class> primitivesPrivate;
    public static final Map<Class, Class> primitives;

    public static Class asNonPrimitive(Class type) {
        if (type.isPrimitive()) {
            return primitives.get(type);
        }
        return type;
    }

    public static Class[] asNonPrimitive(Class[] types2) {
        Class[] results2 = new Class[types2.length];
        for (int i = 0; i < types2.length; ++i) {
            results2[i] = Coercions.asNonPrimitive(types2[i]);
        }
        return results2;
    }

    public static CoercibleType coercibleTypeFor(Type type) {
        if (type == null) {
            return OBJECT;
        }
        if (CoercibleType.class.isInstance(type)) {
            return (CoercibleType)type;
        }
        Coerce coerce = coercionsPrivate.get(type);
        if (coerce == null) {
            return OBJECT;
        }
        return coerce;
    }

    public static final <T> T coerce(Object value2, Type type) {
        Coerce coerce = coercionsPrivate.get(type);
        if (coerce == null) {
            return (T)OBJECT.coerce(value2);
        }
        return coerce.coerce(value2);
    }

    public static final Object coerce(CoercibleType currentType, Object value2, Type type) {
        if (currentType.equals(type)) {
            return value2;
        }
        return currentType.coerce(value2, type);
    }

    public static CoercibleType[] coercibleArray(Fields fields2) {
        return Coercions.coercibleArray(fields2.size(), fields2.getTypes());
    }

    public static CoercibleType[] coercibleArray(int size2, Type[] types2) {
        Object[] coercions = new CoercibleType[size2];
        if (types2 == null) {
            Arrays.fill(coercions, OBJECT);
            return coercions;
        }
        for (int i = 0; i < types2.length; ++i) {
            coercions[i] = Coercions.coercibleTypeFor(types2[i]);
        }
        return coercions;
    }

    public static Class asClass(Type type) {
        if (Class.class.isInstance(type)) {
            return (Class)type;
        }
        return Object.class;
    }

    public static Type asType(String typeName) {
        Type type = typesPrivate.get(typeName);
        if (type != null) {
            return type;
        }
        Class<CoercibleType> typeClass = Coercions.getType(typeName);
        if (CoercibleType.class.isAssignableFrom(typeClass)) {
            return Coercions.getInstance(typeClass);
        }
        return typeClass;
    }

    public static String[] getTypeNames(Type[] types2) {
        String[] names2 = new String[types2.length];
        for (int i = 0; i < types2.length; ++i) {
            names2[i] = Class.class.isInstance(types2[i]) ? ((Class)types2[i]).getName() : types2[i].getClass().getName();
        }
        return names2;
    }

    public static Type[] getTypes(String[] names2) {
        Type[] types2 = new Type[names2.length];
        for (int i = 0; i < names2.length; ++i) {
            types2[i] = Coercions.asType(names2[i]);
        }
        return types2;
    }

    public static Class[] getCanonicalTypes(Type[] types2) {
        Class[] canonicalTypes = new Class[types2.length];
        for (int i = 0; i < types2.length; ++i) {
            canonicalTypes[i] = CoercibleType.class.isInstance(types2[i]) ? ((CoercibleType)types2[i]).getCanonicalType() : (Class)types2[i];
        }
        return canonicalTypes;
    }

    private static CoercibleType getInstance(Class<CoercibleType> typeClass) {
        try {
            return typeClass.newInstance();
        }
        catch (Exception exception) {
            throw new CascadeException("unable to instantiate class: " + Util.getTypeName(typeClass));
        }
    }

    private static Class<?> getType(String typeName) {
        try {
            return Coercions.class.getClassLoader().loadClass(typeName);
        }
        catch (ClassNotFoundException exception) {
            throw new CascadeException("unable to load class: " + typeName);
        }
    }

    static {
        for (Type type : coercionsPrivate.keySet()) {
            typesPrivate.put(Util.getTypeName(type), type);
        }
        primitivesPrivate = new IdentityHashMap<Class, Class>();
        primitives = Collections.unmodifiableMap(primitivesPrivate);
        primitivesPrivate.put(Boolean.TYPE, Boolean.class);
        primitivesPrivate.put(Byte.TYPE, Byte.class);
        primitivesPrivate.put(Short.TYPE, Short.class);
        primitivesPrivate.put(Integer.TYPE, Integer.class);
        primitivesPrivate.put(Long.TYPE, Long.class);
        primitivesPrivate.put(Float.TYPE, Float.class);
        primitivesPrivate.put(Double.TYPE, Double.class);
    }

    public static abstract class Coerce<T>
    implements CoercibleType<T> {
        protected Coerce(Map<Type, Coerce> map2) {
            if (map2.containsKey(this.getCanonicalType())) {
                throw new IllegalStateException("type already exists in map: " + this.getCanonicalType());
            }
            map2.put(this.getCanonicalType(), this);
        }

        @Override
        public T canonical(Object value2) {
            return this.coerce(value2);
        }

        @Override
        public <Coerce> Coerce coerce(Object value2, Type to2) {
            return (Coerce)Coercions.coerce(value2, to2);
        }

        public abstract T coerce(Object var1);

        public int hashCode() {
            return this.getCanonicalType().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CoercibleType)) {
                return false;
            }
            return this.getCanonicalType().equals(((CoercibleType)object).getCanonicalType());
        }
    }
}

