/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.operation.OperationException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleException;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Tuples {
    public static Tuple tuple(Object a) {
        return new Tuple(a);
    }

    public static Tuple tuple(Object a, Object b) {
        return new Tuple(a, b);
    }

    public static Tuple tuple(Object a, Object b, Object c) {
        return new Tuple(a, b, c);
    }

    public static Tuple tuple(Object a, Object b, Object c, Object d) {
        return new Tuple(a, b, c, d);
    }

    public static Tuple tuple(Object a, Object b, Object c, Object d, Object e) {
        return new Tuple(a, b, c, d, e);
    }

    public static Tuple tuple(Object a, Object b, Object c, Object d, Object e, Object f2) {
        return new Tuple(a, b, c, d, e, f2);
    }

    public static Tuple tuple(Object a, Object b, Object c, Object d, Object e, Object f2, Object g) {
        return new Tuple(a, b, c, d, e, f2, g);
    }

    public static Tuple tuple(Object a, Object b, Object c, Object d, Object e, Object f2, Object g, Object h) {
        return new Tuple(a, b, c, d, e, f2, g, h);
    }

    public static <T> T[] asArray(Tuple tuple, T[] destination) {
        if (tuple.size() != destination.length) {
            throw new OperationException("number of input tuple values: " + tuple.size() + ", does not match destination array size: " + destination.length);
        }
        return tuple.elements(destination);
    }

    @Deprecated
    public static Object[] asArray(Tuple tuple, Class[] types2) {
        return Tuples.asArray(tuple, types2, new Object[tuple.size()]);
    }

    @Deprecated
    public static Object[] asArray(Tuple tuple, Class[] types2, Object[] destination) {
        if (tuple.size() != types2.length) {
            throw new OperationException("number of input tuple values: " + tuple.size() + ", does not match number of coercion types: " + types2.length);
        }
        for (int i = 0; i < types2.length; ++i) {
            destination[i] = Tuples.coerce(tuple, i, types2[i]);
        }
        return destination;
    }

    public static Object[] asArray(Tuple tuple, CoercibleType[] coercions, Class[] types2, Object[] destination) {
        if (tuple.size() != types2.length) {
            throw new OperationException("number of input tuple values: " + tuple.size() + ", does not match number of coercion types: " + types2.length);
        }
        for (int i = 0; i < types2.length; ++i) {
            destination[i] = coercions[i].coerce(tuple.getObject(i), types2[i]);
        }
        return destination;
    }

    public static Collection asCollection(Tuple tuple) {
        return Collections.unmodifiableCollection(tuple.elements);
    }

    public static int frequency(Tuple tuple, Object value2) {
        return Collections.frequency(tuple.elements, value2);
    }

    public static int frequency(TupleEntry tupleEntry, Object value2) {
        return Collections.frequency(tupleEntry.getTuple().elements, value2);
    }

    @Deprecated
    public static Object coerce(Tuple tuple, int pos, Class type) {
        Object value2 = tuple.getObject(pos);
        return Tuples.coerce(value2, type);
    }

    @Deprecated
    public static Object coerce(Object value2, Class type) {
        return Coercions.coerce(value2, type);
    }

    @Deprecated
    public static final String toString(Object value2) {
        return Coercions.STRING.coerce(value2);
    }

    @Deprecated
    public static final int toInteger(Object value2) {
        return Coercions.INTEGER.coerce(value2);
    }

    @Deprecated
    public static final long toLong(Object value2) {
        return Coercions.LONG.coerce(value2);
    }

    @Deprecated
    public static final double toDouble(Object value2) {
        return Coercions.DOUBLE.coerce(value2);
    }

    @Deprecated
    public static final float toFloat(Object value2) {
        return Coercions.FLOAT.coerce(value2).floatValue();
    }

    @Deprecated
    public static final short toShort(Object value2) {
        return Coercions.SHORT.coerce(value2);
    }

    @Deprecated
    public static final boolean toBoolean(Object value2) {
        return Coercions.BOOLEAN.coerce(value2);
    }

    @Deprecated
    public static final Integer toIntegerObject(Object value2) {
        return Coercions.INTEGER_OBJECT.coerce(value2);
    }

    @Deprecated
    public static final Long toLongObject(Object value2) {
        return Coercions.LONG_OBJECT.coerce(value2);
    }

    @Deprecated
    public static final Double toDoubleObject(Object value2) {
        return Coercions.DOUBLE_OBJECT.coerce(value2);
    }

    @Deprecated
    public static final Float toFloatObject(Object value2) {
        return Coercions.FLOAT_OBJECT.coerce(value2);
    }

    @Deprecated
    public static final Short toShortObject(Object value2) {
        return Coercions.SHORT_OBJECT.coerce(value2);
    }

    @Deprecated
    public static final Boolean toBooleanObject(Object value2) {
        return Coercions.BOOLEAN_OBJECT.coerce(value2);
    }

    @Deprecated
    public static Tuple coerce(Tuple tuple, Class[] types2) {
        return new Tuple(Tuples.asArray(tuple, types2, new Object[types2.length]));
    }

    @Deprecated
    public static Tuple coerce(Tuple tuple, Class[] types2, Tuple destination) {
        if (tuple.size() != types2.length) {
            throw new OperationException("number of input tuple values: " + tuple.size() + ", does not match number of coercion types: " + types2.length);
        }
        if (destination.size() != types2.length) {
            throw new OperationException("number of destination tuple values: " + destination.size() + ", does not match number of coercion types: " + types2.length);
        }
        for (int i = 0; i < types2.length; ++i) {
            destination.set(i, Tuples.coerce(tuple, i, types2[i]));
        }
        return destination;
    }

    public static Tuple extractTuple(TupleEntry tupleEntry, Fields selector) {
        if (selector == null || selector.isAll()) {
            Tuple result2 = tupleEntry.tuple;
            tupleEntry.setTuple(Tuple.size(result2.size()));
            return result2;
        }
        try {
            return Tuples.extract(tupleEntry, selector);
        }
        catch (Exception exception) {
            throw new TupleException("unable to select from: " + tupleEntry.getFields().printVerbose() + ", using selector: " + selector.printVerbose(), exception);
        }
    }

    public static Tuple extract(TupleEntry tupleEntry, Fields selector) {
        return tupleEntry.tuple.extract(tupleEntry.getFields().getPos(selector, tupleEntry.getFields().size()));
    }

    public static Tuple nulledCopy(TupleEntry tupleEntry, Fields selector) {
        return tupleEntry.tuple.nulledCopy(tupleEntry.getFields().getPos(selector, tupleEntry.getFields().size()));
    }

    public static Tuple nulledCopy(Fields declarator, Tuple tuple, Fields selector) {
        return tuple.nulledCopy(declarator.getPos(selector, declarator.size()));
    }

    public static Tuple setOnEmpty(TupleEntry baseEntry, TupleEntry valuesEntry) {
        Tuple emptyTuple = Tuple.size(baseEntry.getFields().size());
        emptyTuple.set(baseEntry.getFields(), valuesEntry.getFields(), valuesEntry.getTuple());
        return emptyTuple;
    }

    public static Tuple asUnmodifiable(Tuple tuple) {
        tuple.isUnmodifiable = true;
        return tuple;
    }

    public static Tuple asModifiable(Tuple tuple) {
        tuple.isUnmodifiable = false;
        return tuple;
    }

    public static Tuple setUnmodifiable(Tuple tuple, boolean isUnmodifiable) {
        tuple.isUnmodifiable = isUnmodifiable;
        return tuple;
    }

    public static Tuple create(List<Object> arrayList) {
        return new Tuple(arrayList);
    }
}

