/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.flow.FlowProcess;
import cascading.scheme.ConcreteCall;
import cascading.scheme.Scheme;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleException;
import cascading.tuple.Tuples;
import cascading.util.CloseableIterator;
import cascading.util.SingleCloseableInputIterator;
import cascading.util.Util;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleEntrySchemeIterator<Config, Input>
extends TupleEntryIterator {
    private static final Logger LOG = LoggerFactory.getLogger(TupleEntrySchemeIterator.class);
    private final FlowProcess<Config> flowProcess;
    private final Scheme scheme;
    private final CloseableIterator<Input> inputIterator;
    private final Set<Class<? extends Exception>> permittedExceptions;
    private ConcreteCall sourceCall;
    private String identifier;
    private boolean isComplete = false;
    private boolean hasWaiting = false;
    private TupleException currentException;

    public TupleEntrySchemeIterator(FlowProcess<Config> flowProcess, Scheme scheme, Input input2) {
        this(flowProcess, scheme, input2, null);
    }

    public TupleEntrySchemeIterator(FlowProcess<Config> flowProcess, Scheme scheme, Input input2, String identifier2) {
        this(flowProcess, scheme, new SingleCloseableInputIterator((Closeable)input2), identifier2);
    }

    public TupleEntrySchemeIterator(FlowProcess<Config> flowProcess, Scheme scheme, CloseableIterator<Input> inputIterator) {
        this(flowProcess, scheme, inputIterator, (String)null);
    }

    public TupleEntrySchemeIterator(FlowProcess<Config> flowProcess, Scheme scheme, CloseableIterator<Input> inputIterator, String identifier2) {
        super(scheme.getSourceFields());
        this.flowProcess = flowProcess;
        this.scheme = scheme;
        this.inputIterator = inputIterator;
        this.identifier = identifier2;
        Object permittedExceptions = flowProcess.getProperty("cascading.tuple.tupleentryiterator.exceptions.permit");
        this.permittedExceptions = permittedExceptions != null ? Util.asClasses(permittedExceptions.toString(), "unable to load permitted exception class") : Collections.emptySet();
        if (this.identifier == null || this.identifier.isEmpty()) {
            this.identifier = "'unknown'";
        }
        if (!inputIterator.hasNext()) {
            this.isComplete = true;
            return;
        }
        this.sourceCall = new ConcreteCall();
        this.sourceCall.setIncomingEntry(this.getTupleEntry());
        this.sourceCall.setInput(this.wrapInput(inputIterator.next()));
        try {
            this.scheme.sourcePrepare(flowProcess, this.sourceCall);
        }
        catch (IOException exception) {
            throw new TupleException("unable to prepare source for input identifier: " + this.identifier, exception);
        }
    }

    protected FlowProcess<Config> getFlowProcess() {
        return this.flowProcess;
    }

    protected Input wrapInput(Input input2) {
        return input2;
    }

    @Override
    public boolean hasNext() {
        if (this.isComplete) {
            return false;
        }
        if (this.hasWaiting) {
            return true;
        }
        try {
            this.getNext();
        }
        catch (Exception exception) {
            if (this.identifier == null || this.identifier.isEmpty()) {
                this.identifier = "'unknown'";
            }
            if (this.permittedExceptions.contains(exception.getClass())) {
                LOG.warn("Caught permitted exception while reading {}", (Object)this.identifier, (Object)exception);
                return false;
            }
            this.currentException = new TupleException("unable to read from input identifier: " + this.identifier, exception);
            return true;
        }
        if (!this.hasWaiting) {
            this.isComplete = true;
        }
        return !this.isComplete;
    }

    private TupleEntry getNext() throws IOException {
        Tuples.asModifiable(this.sourceCall.getIncomingEntry().getTuple());
        this.hasWaiting = this.scheme.source(this.flowProcess, this.sourceCall);
        if (!this.hasWaiting && this.inputIterator.hasNext()) {
            this.sourceCall.setInput(this.wrapInput(this.inputIterator.next()));
            return this.getNext();
        }
        return this.getTupleEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TupleEntry next() {
        try {
            if (this.currentException != null) {
                throw this.currentException;
            }
        }
        finally {
            this.currentException = null;
        }
        if (this.isComplete) {
            throw new IllegalStateException("no next element");
        }
        try {
            if (this.hasWaiting) {
                TupleEntry tupleEntry = this.getTupleEntry();
                return tupleEntry;
            }
            TupleEntry tupleEntry = this.getNext();
            return tupleEntry;
        }
        catch (Exception exception) {
            throw new TupleException("unable to source from input identifier: " + this.identifier, exception);
        }
        finally {
            this.hasWaiting = false;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("may not remove elements from this iterator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.sourceCall != null) {
                this.scheme.sourceCleanup(this.flowProcess, this.sourceCall);
            }
        }
        finally {
            this.inputIterator.close();
        }
    }
}

