/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.flow.FlowProcess;
import cascading.scheme.ConcreteCall;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleException;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;

public class TupleEntrySchemeCollector<Config, Output>
extends TupleEntryCollector {
    private final FlowProcess<Config> flowProcess;
    private final Scheme scheme;
    private String identifier;
    protected final ConcreteCall<Object, Output> sinkCall;
    private boolean prepared = false;

    public TupleEntrySchemeCollector(FlowProcess<Config> flowProcess, Scheme scheme) {
        this(flowProcess, scheme, null, null);
    }

    public TupleEntrySchemeCollector(FlowProcess<Config> flowProcess, Scheme scheme, String identifier2) {
        this(flowProcess, scheme, null, identifier2);
    }

    public TupleEntrySchemeCollector(FlowProcess<Config> flowProcess, Scheme scheme, Output output) {
        this(flowProcess, scheme, output, null);
    }

    public TupleEntrySchemeCollector(FlowProcess<Config> flowProcess, Tap tap, Output output) {
        this(flowProcess, tap.getScheme(), output, tap.getIdentifier());
    }

    public TupleEntrySchemeCollector(FlowProcess<Config> flowProcess, Scheme scheme, Output output, String identifier2) {
        super(Fields.asDeclaration(scheme.getSinkFields()));
        this.flowProcess = flowProcess;
        this.scheme = scheme;
        this.identifier = identifier2;
        this.sinkCall = new ConcreteCall();
        this.sinkCall.setOutgoingEntry(this.tupleEntry);
        if (output != null) {
            this.setOutput(output);
        }
    }

    protected FlowProcess<Config> getFlowProcess() {
        return this.flowProcess;
    }

    @Override
    public void setFields(Fields declared) {
        super.setFields(declared);
        if (this.sinkCall != null) {
            this.sinkCall.setOutgoingEntry(this.tupleEntry);
        }
    }

    protected Output getOutput() {
        return this.sinkCall.getOutput();
    }

    protected void setOutput(Output output) {
        this.sinkCall.setOutput(this.wrapOutput(output));
    }

    protected Output wrapOutput(Output output) {
        return output;
    }

    protected void prepare() {
        try {
            this.scheme.sinkPrepare(this.flowProcess, this.sinkCall);
        }
        catch (IOException exception) {
            throw new TapException("could not prepare scheme", exception);
        }
        this.prepared = true;
    }

    @Override
    public void add(TupleEntry tupleEntry) {
        if (!this.prepared) {
            this.prepare();
        }
        super.add(tupleEntry);
    }

    @Override
    public void add(Tuple tuple) {
        if (!this.prepared) {
            this.prepare();
        }
        super.add(tuple);
    }

    @Override
    protected void collect(TupleEntry tupleEntry) throws IOException {
        this.sinkCall.setOutgoingEntry(tupleEntry);
        try {
            this.scheme.sink(this.flowProcess, this.sinkCall);
        }
        catch (Exception exception) {
            if (this.identifier == null || this.identifier.isEmpty()) {
                this.identifier = "'unknown'";
            }
            throw new TupleException("unable to sink into output identifier: " + this.identifier, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.sinkCall == null) {
                return;
            }
            try {
                if (this.prepared) {
                    this.scheme.sinkCleanup(this.flowProcess, this.sinkCall);
                }
            }
            catch (IOException exception) {
                throw new TupleException("unable to cleanup sink for output identifier: " + this.identifier, exception);
            }
        }
        finally {
            try {
                if (this.getOutput() instanceof Flushable) {
                    ((Flushable)this.getOutput()).flush();
                }
            }
            catch (IOException exception) {}
            try {
                if (this.getOutput() instanceof Closeable) {
                    ((Closeable)this.getOutput()).close();
                }
            }
            catch (IOException exception) {}
            super.close();
        }
    }
}

