/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleException;
import cascading.tuple.Tuples;
import java.io.IOException;

public abstract class TupleEntryCollector {
    protected TupleEntry tupleEntry = new TupleEntry(Fields.UNKNOWN, null, true);

    protected TupleEntryCollector() {
    }

    public TupleEntryCollector(Fields declared) {
        this.setFields(declared);
    }

    public void setFields(Fields declared) {
        if (declared == null) {
            throw new IllegalArgumentException("declared fields must not be null");
        }
        if (declared.isUnknown() || declared.isAll()) {
            return;
        }
        this.tupleEntry = new TupleEntry(declared, Tuple.size(declared.size()), true);
    }

    public void add(TupleEntry tupleEntry) {
        Fields expectedFields = this.tupleEntry.getFields();
        TupleEntry outgoingEntry = this.tupleEntry;
        if (expectedFields.isUnknown() || expectedFields.equals(tupleEntry.getFields())) {
            outgoingEntry = tupleEntry;
        } else {
            outgoingEntry.setTuple(this.selectTupleFrom(tupleEntry, expectedFields));
        }
        this.safeCollect(outgoingEntry);
    }

    private Tuple selectTupleFrom(TupleEntry tupleEntry, Fields expectedFields) {
        try {
            return tupleEntry.selectTuple(expectedFields);
        }
        catch (TupleException exception) {
            Fields givenFields = tupleEntry.getFields();
            String string2 = "given TupleEntry fields: " + givenFields.printVerbose();
            string2 = string2 + " do not match the operation declaredFields: " + expectedFields.printVerbose();
            string2 = string2 + ", operations must emit tuples that match the fields they declare as output";
            throw new TupleException(string2, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Tuple tuple) {
        if (!this.tupleEntry.getFields().isUnknown() && this.tupleEntry.getFields().size() != tuple.size()) {
            throw new TupleException("operation added the wrong number of fields, expected: " + this.tupleEntry.getFields().print() + ", got result size: " + tuple.size());
        }
        boolean isUnmodifiable = tuple.isUnmodifiable();
        this.tupleEntry.setTuple(tuple);
        try {
            this.safeCollect(this.tupleEntry);
        }
        finally {
            Tuples.setUnmodifiable(tuple, isUnmodifiable);
        }
    }

    private void safeCollect(TupleEntry tupleEntry) {
        try {
            this.collect(tupleEntry);
        }
        catch (IOException exception) {
            throw new TupleException("unable to collect tuple", exception);
        }
    }

    protected abstract void collect(TupleEntry var1) throws IOException;

    public void close() {
    }
}

