/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public class TupleEntryChainIterator
extends TupleEntryIterator {
    Iterator<Tuple>[] iterators;
    int currentIterator = 0;

    public TupleEntryChainIterator(Fields fields2, Iterator<Tuple> ... iterators) {
        super(fields2);
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        if (this.iterators.length < this.currentIterator + 1) {
            return false;
        }
        if (this.iterators[this.currentIterator].hasNext()) {
            return true;
        }
        this.closeCurrent();
        ++this.currentIterator;
        return this.iterators.length != this.currentIterator && this.hasNext();
    }

    public void reset(Iterator<Tuple> ... iterators) {
        this.currentIterator = 0;
        this.iterators = iterators;
    }

    @Override
    public TupleEntry next() {
        this.hasNext();
        this.entry.setTuple(this.iterators[this.currentIterator].next());
        return this.entry;
    }

    @Override
    public void remove() {
        this.iterators[this.currentIterator].remove();
    }

    @Override
    public void close() {
        if (this.iterators.length != this.currentIterator) {
            this.closeCurrent();
        }
    }

    protected void closeCurrent() {
        this.close(this.iterators[this.currentIterator]);
    }

    private void close(Iterator iterator2) {
        if (iterator2 instanceof Closeable) {
            try {
                ((Closeable)((Object)iterator2)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

