/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.Tuples;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.util.ForeverValueIterator;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TupleEntry {
    private static final Logger LOG = LoggerFactory.getLogger(TupleEntry.class);
    private static final CoercibleType[] EMPTY_COERCIONS = new CoercibleType[0];
    private static final ForeverValueIterator<CoercibleType> OBJECT_ITERATOR = new ForeverValueIterator<Coercions.Coerce<Object>>(Coercions.OBJECT);
    public static final TupleEntry NULL = new TupleEntry(Fields.NONE, Tuple.NULL);
    private Fields fields;
    private CoercibleType[] coercions = EMPTY_COERCIONS;
    private boolean isUnmodifiable = false;
    Tuple tuple;

    public static Tuple select(Fields selector, TupleEntry ... entries) {
        Tuple result2 = null;
        if (selector.isAll()) {
            for (TupleEntry entry2 : entries) {
                result2 = result2 == null ? entry2.getTuple() : result2.append(entry2.getTuple());
            }
            return result2;
        }
        int size2 = 0;
        for (TupleEntry entry3 : entries) {
            size2 += entry3.size();
        }
        result2 = Tuple.size(selector.size());
        int offset = 0;
        for (TupleEntry entry4 : entries) {
            for (int i = 0; i < selector.size(); ++i) {
                int pos;
                Comparable field2 = selector.get(i);
                if (field2 instanceof String ? (pos = entry4.fields.indexOfSafe(field2)) == -1 : (pos = entry4.fields.translatePos((Integer)field2, size2) - offset) >= entry4.size() || pos < 0) continue;
                result2.set(i, entry4.getObject(pos));
            }
            offset += entry4.size();
        }
        return result2;
    }

    public TupleEntry() {
        this.fields = Fields.NONE;
        this.setCoercions();
    }

    @ConstructorProperties(value={"isUnmodifiable"})
    public TupleEntry(boolean isUnmodifiable) {
        this.fields = Fields.NONE;
        this.isUnmodifiable = isUnmodifiable;
        this.setCoercions();
    }

    @ConstructorProperties(value={"fields"})
    public TupleEntry(Fields fields2) {
        this.fields = fields2;
        this.setCoercions();
    }

    @ConstructorProperties(value={"fields", "isUnmodifiable"})
    public TupleEntry(Fields fields2, boolean isUnmodifiable) {
        this.fields = fields2;
        this.isUnmodifiable = isUnmodifiable;
        this.setCoercions();
    }

    @ConstructorProperties(value={"fields", "tuple", "isUnmodifiable"})
    public TupleEntry(Fields fields2, Tuple tuple, boolean isUnmodifiable) {
        this.fields = fields2;
        this.isUnmodifiable = isUnmodifiable;
        this.setTuple(tuple);
        this.setCoercions();
    }

    @ConstructorProperties(value={"fields", "tuple"})
    public TupleEntry(Fields fields2, Tuple tuple) {
        this.fields = fields2;
        this.tuple = tuple;
        this.setCoercions();
    }

    @ConstructorProperties(value={"tupleEntry"})
    public TupleEntry(TupleEntry tupleEntry) {
        this.fields = tupleEntry.getFields();
        this.tuple = tupleEntry.getTupleCopy();
        this.setCoercions();
    }

    @ConstructorProperties(value={"tuple"})
    public TupleEntry(Tuple tuple) {
        this.fields = Fields.size(tuple.size());
        this.tuple = tuple;
        this.setCoercions();
    }

    private void setCoercions() {
        if (this.coercions != EMPTY_COERCIONS) {
            return;
        }
        Fields fields2 = this.getFields();
        Type[] types2 = fields2.types;
        int size2 = fields2.size();
        int n = size2 = size2 == 0 && this.tuple != null ? this.tuple.size() : size2;
        if (this.coercions.length < size2) {
            this.coercions = Coercions.coercibleArray(size2, types2);
        }
    }

    public boolean isUnmodifiable() {
        return this.isUnmodifiable;
    }

    public Fields getFields() {
        return this.fields;
    }

    public boolean hasTypes() {
        return this.fields.hasTypes();
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public Tuple getTupleCopy() {
        return new Tuple(this.tuple);
    }

    public Tuple getCoercedTuple(Type[] types2) {
        return this.getCoercedTuple(types2, Tuple.size(types2.length));
    }

    public Tuple getCoercedTuple(Type[] types2, Tuple into) {
        if (this.coercions.length != types2.length || types2.length != into.size()) {
            throw new IllegalArgumentException("current entry and given tuple and types must be same length");
        }
        for (int i = 0; i < this.coercions.length; ++i) {
            Object element = this.tuple.getObject(i);
            into.set(i, Coercions.coerce(this.coercions[i], element, types2[i]));
        }
        return into;
    }

    public void setTuple(Tuple tuple) {
        if (!this.isUnmodifiable && tuple.isUnmodifiable()) {
            throw new IllegalArgumentException("current entry is modifiable but given tuple is not modifiable, make copy of given Tuple first");
        }
        this.tuple = tuple != null && this.isUnmodifiable ? Tuples.asUnmodifiable(tuple) : tuple;
        this.setCoercions();
    }

    public void setCanonicalTuple(Tuple tuple) {
        if (this.isUnmodifiable) {
            tuple = Tuples.asUnmodifiable(tuple);
        }
        if (this.fields.size() != tuple.size()) {
            throw new IllegalArgumentException("current entry and given tuple must be same length");
        }
        for (int i = 0; i < this.coercions.length; ++i) {
            Object element = tuple.getObject(i);
            this.tuple.set(i, this.coercions[i].canonical(element));
        }
    }

    public void setCanonicalValues(Object[] values2) {
        if (this.fields.size() != values2.length) {
            throw new IllegalArgumentException("current entry and given array must be same length");
        }
        for (int i = 0; i < this.coercions.length; ++i) {
            Object element = values2[i];
            this.tuple.set(i, this.coercions[i].canonical(element));
        }
    }

    public int size() {
        return this.tuple.size();
    }

    @Deprecated
    public Comparable get(int pos) {
        return this.tuple.get(pos);
    }

    public Object getObject(int pos) {
        return this.tuple.getObject(pos);
    }

    public Object getObject(int pos, Type type) {
        return Coercions.coerce(this.coercions[pos], this.tuple.getObject(pos), type);
    }

    @Deprecated
    public Comparable get(Comparable fieldName) {
        return this.tuple.get(this.fields.getPos(this.asFieldName(fieldName)));
    }

    public Object getObject(Comparable fieldName) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        return this.tuple.getObject(pos);
    }

    public Object getObject(Comparable fieldName, Type type) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        return Coercions.coerce(this.coercions[pos], this.tuple.getObject(pos), type);
    }

    @Deprecated
    public void set(Comparable fieldName, Object value2) {
        this.tuple.set(this.fields.getPos(this.asFieldName(fieldName)), value2);
    }

    public void setRaw(int pos, Object value2) {
        this.tuple.set(pos, value2);
    }

    public void setRaw(Comparable fieldName, Object value2) {
        this.tuple.set(this.fields.getPos(this.asFieldName(fieldName)), value2);
    }

    public void setObject(Comparable fieldName, Object value2) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        this.tuple.set(pos, this.coercions[pos].canonical(value2));
    }

    public void setBoolean(Comparable fieldName, boolean value2) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        this.tuple.set(pos, this.coercions[pos].canonical(value2));
    }

    public void setShort(Comparable fieldName, short value2) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        this.tuple.set(pos, this.coercions[pos].canonical(value2));
    }

    public void setInteger(Comparable fieldName, int value2) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        this.tuple.set(pos, this.coercions[pos].canonical(value2));
    }

    public void setLong(Comparable fieldName, long value2) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        this.tuple.set(pos, this.coercions[pos].canonical(value2));
    }

    public void setFloat(Comparable fieldName, float value2) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        this.tuple.set(pos, this.coercions[pos].canonical(Float.valueOf(value2)));
    }

    public void setDouble(Comparable fieldName, double value2) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        this.tuple.set(pos, this.coercions[pos].canonical(value2));
    }

    public void setString(Comparable fieldName, String value2) {
        int pos = this.fields.getPos(this.asFieldName(fieldName));
        this.tuple.set(pos, this.coercions[pos].canonical(value2));
    }

    public String getString(Comparable fieldName) {
        return (String)this.getObject(fieldName, (Type)((Object)String.class));
    }

    public float getFloat(Comparable fieldName) {
        return ((Float)this.getObject(fieldName, Float.TYPE)).floatValue();
    }

    public double getDouble(Comparable fieldName) {
        return (Double)this.getObject(fieldName, Double.TYPE);
    }

    public int getInteger(Comparable fieldName) {
        return (Integer)this.getObject(fieldName, Integer.TYPE);
    }

    public long getLong(Comparable fieldName) {
        return (Long)this.getObject(fieldName, Long.TYPE);
    }

    public short getShort(Comparable fieldName) {
        return (Short)this.getObject(fieldName, Short.TYPE);
    }

    public boolean getBoolean(Comparable fieldName) {
        return (Boolean)this.getObject(fieldName, Boolean.TYPE);
    }

    private Comparable asFieldName(Comparable fieldName) {
        return Fields.asFieldName(fieldName);
    }

    public TupleEntry selectEntry(Fields selector) {
        if (selector == null || selector.isAll() || this.fields == selector) {
            return this;
        }
        if (selector.isNone()) {
            return this.isUnmodifiable ? NULL : new TupleEntry();
        }
        return new TupleEntry(Fields.asDeclaration(selector), this.tuple.get(this.fields, selector), this.isUnmodifiable);
    }

    public TupleEntry selectEntryCopy(Fields selector) {
        if (selector == null || selector.isAll() || this.fields == selector) {
            return new TupleEntry(this);
        }
        if (selector.isNone()) {
            return new TupleEntry();
        }
        return new TupleEntry(Fields.asDeclaration(selector), this.tuple.get(this.fields, selector));
    }

    public Tuple selectTuple(Fields selector) {
        if (selector == null || selector.isAll() || this.fields == selector) {
            return this.tuple;
        }
        if (selector.isNone()) {
            return Tuple.NULL;
        }
        Tuple result2 = this.tuple.get(this.fields, selector);
        if (this.isUnmodifiable) {
            Tuples.asUnmodifiable(result2);
        }
        return result2;
    }

    public Tuple selectTupleCopy(Fields selector) {
        if (selector == null || selector.isAll() || this.fields == selector) {
            return new Tuple(this.tuple);
        }
        if (selector.isNone()) {
            return new Tuple();
        }
        return this.tuple.get(this.fields, selector);
    }

    public Tuple selectInto(Fields selector, Tuple tuple) {
        if (selector.isNone()) {
            return tuple;
        }
        int[] pos = this.tuple.getPos(this.fields, selector);
        if (pos == null || pos.length == 0) {
            tuple.addAll(this.tuple);
        } else {
            for (int i : pos) {
                tuple.add(this.tuple.getObject(i));
            }
        }
        return tuple;
    }

    public void setTuple(Fields selector, Tuple tuple) {
        if (selector == null || selector.isAll()) {
            this.tuple.setAll(tuple);
        } else {
            this.tuple.set(this.fields, selector, tuple);
        }
    }

    public void set(TupleEntry tupleEntry) {
        this.tuple.set(this.fields, tupleEntry.getFields(), tupleEntry.getTuple(), tupleEntry.coercions);
    }

    public TupleEntry appendNew(TupleEntry entry2) {
        Fields appendedFields = this.fields.append(entry2.fields.isUnknown() ? Fields.size(entry2.tuple.size()) : entry2.fields);
        Tuple appendedTuple = this.tuple.append(entry2.tuple);
        return new TupleEntry(appendedFields, appendedTuple);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TupleEntry)) {
            return false;
        }
        TupleEntry that = (TupleEntry)object;
        if (this.fields != null ? !this.fields.equals(that.fields) : that.fields != null) {
            return false;
        }
        return !(this.tuple != null ? this.fields.compare(this.tuple, that.tuple) != 0 : that.tuple != null);
    }

    public int hashCode() {
        int result2 = this.fields != null ? this.fields.hashCode() : 0;
        result2 = 31 * result2 + (this.tuple != null ? this.tuple.hashCode() : 0);
        return result2;
    }

    public String toString() {
        if (this.fields == null) {
            return "empty";
        }
        if (this.tuple == null) {
            return "fields: " + this.fields.print();
        }
        return "fields: " + this.fields.print() + " tuple: " + this.tuple.print();
    }

    public <T> Iterable<T> asIterableOf(final Class<T> type) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final ForeverValueIterator coercibleIterator = TupleEntry.this.coercions.length == 0 ? OBJECT_ITERATOR : Arrays.asList(TupleEntry.this.coercions).iterator();
                final Iterator<Object> valuesIterator = TupleEntry.this.tuple.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return valuesIterator.hasNext();
                    }

                    @Override
                    public T next() {
                        Object next2 = valuesIterator.next();
                        return ((CoercibleType)coercibleIterator.next()).coerce(next2, type);
                    }

                    @Override
                    public void remove() {
                        valuesIterator.remove();
                    }
                };
            }
        };
    }
}

