/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.Fields;
import cascading.tuple.TupleException;
import cascading.tuple.Tuples;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;

public class Tuple
implements Comparable<Object>,
Iterable<Object>,
Serializable {
    public static final Tuple NULL = Tuples.asUnmodifiable(new Tuple());
    private static final String printDelim = "\t";
    protected transient boolean isUnmodifiable = false;
    protected List<Object> elements;

    public static Tuple size(int size2) {
        return Tuple.size(size2, null);
    }

    public static Tuple size(int size2, Comparable value2) {
        Tuple result2 = new Tuple(new ArrayList<Object>(size2));
        for (int i = 0; i < size2; ++i) {
            result2.add(value2);
        }
        return result2;
    }

    @Deprecated
    public static Tuple parse(String string2) {
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        string2 = string2.replaceAll("^ *\\[*", "");
        string2 = string2.replaceAll("\\]* *$", "");
        Scanner scanner = new Scanner(new StringReader(string2));
        scanner.useDelimiter("(' *, *')|(^ *')|(' *$)");
        Tuple result2 = new Tuple();
        while (scanner.hasNext()) {
            if (scanner.hasNextInt()) {
                result2.add(Integer.valueOf(scanner.nextInt()));
                continue;
            }
            if (scanner.hasNextDouble()) {
                result2.add(Double.valueOf(scanner.nextDouble()));
                continue;
            }
            result2.add((Comparable)((Object)scanner.next()));
        }
        scanner.close();
        return result2;
    }

    public static List<Object> elements(Tuple tuple) {
        return tuple.elements;
    }

    protected Tuple(List<Object> elements) {
        this.elements = elements;
    }

    public Tuple() {
        this(new ArrayList<Object>());
    }

    @ConstructorProperties(value={"tuple"})
    public Tuple(Tuple tuple) {
        this(new ArrayList<Object>(tuple.elements));
    }

    @ConstructorProperties(value={"values"})
    public Tuple(Object ... values2) {
        this(new ArrayList<Object>(values2.length));
        Collections.addAll(this.elements, values2);
    }

    public boolean isUnmodifiable() {
        return this.isUnmodifiable;
    }

    @Deprecated
    public Comparable get(int pos) {
        return (Comparable)this.elements.get(pos);
    }

    public Object getObject(int pos) {
        return this.elements.get(pos);
    }

    public char getChar(int pos) {
        return Coercions.CHARACTER.coerce(this.getObject(pos)).charValue();
    }

    public String getString(int pos) {
        return Coercions.STRING.coerce(this.getObject(pos));
    }

    public float getFloat(int pos) {
        return Coercions.FLOAT.coerce(this.getObject(pos)).floatValue();
    }

    public double getDouble(int pos) {
        return Coercions.DOUBLE.coerce(this.getObject(pos));
    }

    public int getInteger(int pos) {
        return Coercions.INTEGER.coerce(this.getObject(pos));
    }

    public long getLong(int pos) {
        return Coercions.LONG.coerce(this.getObject(pos));
    }

    public short getShort(int pos) {
        return Coercions.SHORT.coerce(this.getObject(pos));
    }

    public boolean getBoolean(int pos) {
        return Coercions.BOOLEAN.coerce(this.getObject(pos));
    }

    public Tuple get(int[] pos) {
        if (pos == null || pos.length == 0) {
            return new Tuple(this);
        }
        Tuple results2 = new Tuple();
        for (int i : pos) {
            results2.add(this.elements.get(i));
        }
        return results2;
    }

    public Tuple get(Fields declarator, Fields selector) {
        try {
            return this.get(this.getPos(declarator, selector));
        }
        catch (Exception exception) {
            throw new TupleException("unable to select from: " + declarator.print() + ", using selector: " + selector.print(), exception);
        }
    }

    public int[] getPos(Fields declarator, Fields selector) {
        if (!declarator.isUnknown() && this.elements.size() != declarator.size()) {
            throw new TupleException("field declaration: " + declarator.print() + ", does not match tuple: " + this.print());
        }
        return declarator.getPos(selector, this.size());
    }

    public Tuple leave(int[] pos) {
        this.verifyModifiable();
        Tuple results2 = this.remove(pos);
        List<Object> temp = results2.elements;
        results2.elements = this.elements;
        this.elements = temp;
        return results2;
    }

    public void clear() {
        this.verifyModifiable();
        this.elements.clear();
    }

    public void add(Comparable value2) {
        this.add((Object)value2);
    }

    public void add(Object value2) {
        this.verifyModifiable();
        this.elements.add(value2);
    }

    public void addBoolean(boolean value2) {
        this.verifyModifiable();
        this.elements.add(value2);
    }

    public void addShort(short value2) {
        this.verifyModifiable();
        this.elements.add(value2);
    }

    public void addInteger(int value2) {
        this.verifyModifiable();
        this.elements.add(value2);
    }

    public void addLong(long value2) {
        this.verifyModifiable();
        this.elements.add(value2);
    }

    public void addFloat(float value2) {
        this.verifyModifiable();
        this.elements.add(Float.valueOf(value2));
    }

    public void addDouble(double value2) {
        this.verifyModifiable();
        this.elements.add(value2);
    }

    public void addString(String value2) {
        this.verifyModifiable();
        this.elements.add(value2);
    }

    public void addAll(Object ... values2) {
        this.verifyModifiable();
        if (values2.length == 1 && values2[0] instanceof Tuple) {
            this.addAll((Tuple)values2[0]);
        } else {
            Collections.addAll(this.elements, values2);
        }
    }

    public void addAll(Tuple tuple) {
        this.verifyModifiable();
        if (tuple != null) {
            this.elements.addAll(tuple.elements);
        }
    }

    public void setAll(Tuple tuple) {
        this.verifyModifiable();
        if (tuple == null) {
            return;
        }
        for (int i = 0; i < tuple.elements.size(); ++i) {
            this.internalSet(i, tuple.elements.get(i));
        }
    }

    public void setAll(Tuple ... tuples) {
        this.verifyModifiable();
        if (tuples.length == 0) {
            return;
        }
        int pos = 0;
        for (int i = 0; i < tuples.length; ++i) {
            Tuple tuple = tuples[i];
            if (tuple == null) continue;
            for (int j = 0; j < tuple.elements.size(); ++j) {
                this.internalSet(pos++, tuple.elements.get(j));
            }
        }
    }

    public void set(int index2, Object value2) {
        this.verifyModifiable();
        this.internalSet(index2, value2);
    }

    public void setBoolean(int index2, boolean value2) {
        this.verifyModifiable();
        this.internalSet(index2, value2);
    }

    public void setShort(int index2, short value2) {
        this.verifyModifiable();
        this.internalSet(index2, value2);
    }

    public void setInteger(int index2, int value2) {
        this.verifyModifiable();
        this.internalSet(index2, value2);
    }

    public void setLong(int index2, long value2) {
        this.verifyModifiable();
        this.internalSet(index2, value2);
    }

    public void setFloat(int index2, float value2) {
        this.verifyModifiable();
        this.internalSet(index2, Float.valueOf(value2));
    }

    public void setDouble(int index2, double value2) {
        this.verifyModifiable();
        this.internalSet(index2, value2);
    }

    public void setString(int index2, String value2) {
        this.verifyModifiable();
        this.internalSet(index2, value2);
    }

    protected final void internalSet(int index2, Object value2) {
        try {
            this.elements.set(index2, value2);
        }
        catch (IndexOutOfBoundsException exception) {
            if (this.elements.size() != 0) {
                throw new TupleException("failed to set a value beyond the end of the tuple elements array, size: " + this.size() + " , index: " + index2);
            }
            throw new TupleException("failed to set a value, tuple may not be initialized with values, is zero length");
        }
    }

    public void put(Fields declarator, Fields fields2, Tuple tuple) {
        this.verifyModifiable();
        int[] pos = this.getPos(declarator, fields2);
        for (int i = 0; i < pos.length; ++i) {
            this.internalSet(pos[i], tuple.getObject(i));
        }
    }

    public Tuple remove(int[] pos) {
        this.verifyModifiable();
        int[] offset = new int[pos.length];
        for (int i = 0; i < pos.length; ++i) {
            offset[i] = 0;
            for (int j = 0; j < i; ++j) {
                if (pos[j] >= pos[i]) continue;
                int n = i;
                offset[n] = offset[n] + 1;
            }
        }
        Tuple results2 = new Tuple();
        for (int i = 0; i < pos.length; ++i) {
            results2.add(this.elements.remove(pos[i] - offset[i]));
        }
        return results2;
    }

    public Tuple remove(Fields declarator, Fields selector) {
        return this.remove(this.getPos(declarator, selector));
    }

    Tuple extract(int[] pos) {
        Tuple results2 = new Tuple();
        for (int i : pos) {
            results2.add((Object)this.elements.set(i, null));
        }
        return results2;
    }

    Tuple nulledCopy(int[] pos) {
        if (pos == null) {
            return Tuple.size(this.size());
        }
        Tuple results2 = new Tuple(this);
        for (int i : pos) {
            results2.set(i, null);
        }
        return results2;
    }

    void set(int[] pos, Tuple tuple) {
        this.verifyModifiable();
        if (pos.length != tuple.size()) {
            throw new TupleException("given tuple not same size as position array: " + pos.length + ", tuple: " + tuple.print());
        }
        int count2 = 0;
        for (int i : pos) {
            this.elements.set(i, tuple.elements.get(count2++));
        }
    }

    private void set(int[] pos, Type[] types2, Tuple tuple, CoercibleType[] coercions) {
        this.verifyModifiable();
        if (pos.length != tuple.size()) {
            throw new TupleException("given tuple not same size as position array: " + pos.length + ", tuple: " + tuple.print());
        }
        int count2 = 0;
        for (int i : pos) {
            Object element = tuple.elements.get(count2);
            Type type = types2[count2++];
            element = coercions[i].coerce(element, type);
            this.elements.set(i, element);
        }
    }

    public void set(Fields declarator, Fields selector, Tuple tuple) {
        try {
            this.set(declarator.getPos(selector), tuple);
        }
        catch (Exception exception) {
            throw new TupleException("unable to set into: " + declarator.print() + ", using selector: " + selector.print(), exception);
        }
    }

    protected void set(Fields declarator, Fields selector, Tuple tuple, CoercibleType[] coercions) {
        try {
            this.set(declarator.getPos(selector), declarator.getTypes(), tuple, coercions);
        }
        catch (Exception exception) {
            throw new TupleException("unable to set into: " + declarator.print() + ", using selector: " + selector.print(), exception);
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return this.elements.iterator();
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public int size() {
        return this.elements.size();
    }

    private Object[] elements() {
        return this.elements.toArray();
    }

    <T> T[] elements(T[] destination) {
        return this.elements.toArray(destination);
    }

    public Class[] getTypes() {
        Class[] types2 = new Class[this.elements.size()];
        for (int i = 0; i < this.elements.size(); ++i) {
            Object value2 = this.elements.get(i);
            if (value2 == null) continue;
            types2[i] = value2.getClass();
        }
        return types2;
    }

    public Tuple append(Tuple ... tuples) {
        Tuple result2 = new Tuple(this);
        for (Tuple tuple : tuples) {
            result2.addAll(tuple);
        }
        return result2;
    }

    @Override
    public int compareTo(Tuple other) {
        if (other == null || other.elements == null) {
            return 1;
        }
        if (other.elements.size() != this.elements.size()) {
            return this.elements.size() - other.elements.size();
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Comparable lhs = (Comparable)this.elements.get(i);
            Comparable rhs = (Comparable)other.elements.get(i);
            if (lhs == null && rhs == null) continue;
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            int c = lhs.compareTo(rhs);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public int compareTo(Comparator[] comparators, Tuple other) {
        if (comparators == null) {
            return this.compareTo(other);
        }
        if (other == null || other.elements == null) {
            return 1;
        }
        if (other.elements.size() != this.elements.size()) {
            return this.elements.size() - other.elements.size();
        }
        if (comparators.length != this.elements.size()) {
            throw new IllegalArgumentException("comparator array not same size as tuple elements");
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            int c;
            Object lhs = this.elements.get(i);
            Object rhs = other.elements.get(i);
            if (comparators[i] != null) {
                c = comparators[i].compare(lhs, rhs);
            } else if (lhs == null && rhs == null) {
                c = 0;
            } else {
                if (lhs == null) {
                    return -1;
                }
                if (rhs == null) {
                    return 1;
                }
                c = ((Comparable)lhs).compareTo(rhs);
            }
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public int compareTo(Object other) {
        if (other instanceof Tuple) {
            return this.compareTo((Tuple)other);
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)object;
        if (this.elements.size() != other.elements.size()) {
            return false;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Object lhs = this.elements.get(i);
            Object rhs = other.elements.get(i);
            if (lhs == null && rhs == null) continue;
            if (lhs == null || rhs == null) {
                return false;
            }
            if (lhs.equals(rhs)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash2 = 1;
        for (Object element : this.elements) {
            hash2 = 31 * hash2 + (element != null ? element.hashCode() : 0);
        }
        return hash2;
    }

    public String toString() {
        return Util.join(this.elements, printDelim, true);
    }

    public String toString(String delim) {
        return Util.join(this.elements, delim, true);
    }

    public String toString(String delim, boolean printNull) {
        return Util.join(this.elements, delim, printNull);
    }

    public String format(String format2) {
        return String.format(format2, this.elements());
    }

    public String print() {
        return this.printTo(new StringBuffer()).toString();
    }

    public StringBuffer printTo(StringBuffer buffer2) {
        buffer2.append("[");
        if (this.elements != null) {
            for (int i = 0; i < this.elements.size(); ++i) {
                Object element = this.elements.get(i);
                if (element instanceof Tuple) {
                    ((Tuple)element).printTo(buffer2);
                } else if (element == null) {
                    buffer2.append(element);
                } else {
                    buffer2.append("'").append(element).append("'");
                }
                if (i >= this.elements.size() - 1) continue;
                buffer2.append(", ");
            }
        }
        buffer2.append("]");
        return buffer2;
    }

    private final void verifyModifiable() {
        if (this.isUnmodifiable) {
            throw new UnsupportedOperationException("this tuple is unmodifiable");
        }
    }
}

