/*
 * Decompiled with CFR 0.152.
 */
package cascading.tuple;

import cascading.tuple.FieldsResolverException;
import cascading.tuple.Tuple;
import cascading.tuple.TupleException;
import cascading.tuple.type.CoercibleType;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class Fields
implements Comparable,
Iterable<Comparable>,
Serializable,
Comparator<Tuple> {
    public static final Fields UNKNOWN = new Fields(Kind.UNKNOWN);
    public static final Fields NONE = new Fields(Kind.NONE);
    public static final Fields ALL = new Fields(Kind.ALL);
    public static final Fields GROUP = new Fields(Kind.GROUP);
    public static final Fields VALUES = new Fields(Kind.VALUES);
    public static final Fields ARGS = new Fields(Kind.ARGS);
    public static final Fields RESULTS = new Fields(Kind.RESULTS);
    public static final Fields REPLACE = new Fields(Kind.REPLACE);
    public static final Fields SWAP = new Fields(Kind.SWAP);
    public static final Fields FIRST = new Fields(Integer.valueOf(0));
    public static final Fields LAST = new Fields(Integer.valueOf(-1));
    private static final int[] EMPTY_INT = new int[0];
    Comparable[] fields = new Comparable[0];
    boolean isOrdered = true;
    Kind kind;
    Type[] types;
    Comparator[] comparators;
    transient int[] thisPos;
    transient Map<Comparable, Integer> index;
    transient Map<Fields, int[]> posCache;
    transient int hashCode;

    public static Fields[] fields(Fields ... fields2) {
        return fields2;
    }

    public static Comparable[] names(Comparable ... names2) {
        return names2;
    }

    public static Type[] types(Type ... types2) {
        return types2;
    }

    public static Fields size(int size2) {
        if (size2 == 0) {
            return NONE;
        }
        Fields fields2 = new Fields();
        fields2.fields = Fields.expand(size2, 0);
        return fields2;
    }

    public static Fields size(int size2, Type type) {
        if (size2 == 0) {
            return NONE;
        }
        Fields fields2 = new Fields();
        fields2.fields = Fields.expand(size2, 0);
        for (Comparable field2 : fields2) {
            fields2.applyType(field2, type);
        }
        return fields2;
    }

    public static Fields join(Fields ... fields2) {
        return Fields.join(false, fields2);
    }

    public static Fields join(boolean maskDuplicateNames, Fields ... fields2) {
        Type[] types2;
        int size2 = 0;
        for (Fields field2 : fields2) {
            if (field2.isSubstitution() || field2.isUnknown()) {
                throw new TupleException("cannot join fields if one is a substitution or is unknown");
            }
            size2 += field2.size();
        }
        if (size2 == 0) {
            return NONE;
        }
        Comparable[] elements = Fields.join(size2, fields2);
        if (maskDuplicateNames) {
            HashSet<String> names2 = new HashSet<String>();
            for (int i = elements.length - 1; i >= 0; --i) {
                Comparable element = elements[i];
                if (names2.contains(element)) {
                    elements[i] = Integer.valueOf(i);
                    continue;
                }
                if (!(element instanceof String)) continue;
                names2.add((String)((Object)element));
            }
        }
        if ((types2 = Fields.joinTypes(size2, fields2)) == null) {
            return new Fields(elements);
        }
        return new Fields(elements, types2);
    }

    private static Comparable[] join(int size2, Fields ... fields2) {
        Comparable[] elements = Fields.expand(size2, 0);
        int pos = 0;
        for (Fields field2 : fields2) {
            System.arraycopy(field2.fields, 0, elements, pos, field2.size());
            pos += field2.size();
        }
        return elements;
    }

    private static Type[] joinTypes(int size2, Fields ... fields2) {
        Type[] elements = new Type[size2];
        int pos = 0;
        for (Fields field2 : fields2) {
            if (field2.isNone()) continue;
            if (field2.types == null) {
                return null;
            }
            System.arraycopy(field2.types, 0, elements, pos, field2.size());
            pos += field2.size();
        }
        return elements;
    }

    public static Fields mask(Fields fields2, Fields mask) {
        Comparable[] elements = Fields.expand(fields2.size(), 0);
        System.arraycopy(fields2.fields, 0, elements, 0, elements.length);
        for (int i = elements.length - 1; i >= 0; --i) {
            Comparable element = elements[i];
            if (element instanceof Integer || !mask.getIndex().containsKey(element)) continue;
            elements[i] = Integer.valueOf(i);
        }
        return new Fields(elements);
    }

    public static Fields merge(Fields ... fields2) {
        ArrayList<Comparable> elements = new ArrayList<Comparable>();
        ArrayList<Type> elementTypes = new ArrayList<Type>();
        for (Fields field2 : fields2) {
            Type[] types2 = field2.getTypes();
            int i = 0;
            for (Comparable comparable : field2) {
                if (!elements.contains(comparable)) {
                    elements.add(comparable);
                    elementTypes.add(types2 == null ? null : types2[i]);
                }
                ++i;
            }
        }
        Comparable[] comparables = elements.toArray(new Comparable[elements.size()]);
        Object[] types3 = elementTypes.toArray(new Type[elementTypes.size()]);
        if (Util.containsNull(types3)) {
            return new Fields(comparables);
        }
        return new Fields(comparables, (Type[])types3);
    }

    public static Fields copyComparators(Fields toFields2, Fields ... fromFields) {
        for (Fields fromField : fromFields) {
            for (Comparable field2 : fromField) {
                Comparator comparator = fromField.getComparator(field2);
                if (comparator == null) continue;
                toFields2.setComparator(field2, comparator);
            }
        }
        return toFields2;
    }

    public static Fields offsetSelector(int size2, int startPos) {
        Fields fields2 = new Fields();
        fields2.isOrdered = false;
        fields2.fields = Fields.expand(size2, startPos);
        return fields2;
    }

    private static Comparable[] expand(int size2, int startPos) {
        if (size2 < 1) {
            throw new TupleException("invalid size for fields: " + size2);
        }
        if (startPos < 0) {
            throw new TupleException("invalid start position for fields: " + startPos);
        }
        Comparable[] fields2 = new Comparable[size2];
        for (int i = 0; i < fields2.length; ++i) {
            fields2[i] = Integer.valueOf(i + startPos);
        }
        return fields2;
    }

    public static Fields resolve(Fields selector, Fields ... fields2) {
        int i;
        boolean hasUnknowns = false;
        int size2 = 0;
        for (Fields field2 : fields2) {
            if (field2.isUnknown()) {
                hasUnknowns = true;
            }
            if (!field2.isDefined() && field2.isUnOrdered()) {
                throw new TupleException("unable to select from field set: " + field2.printVerbose());
            }
            size2 += field2.size();
        }
        if (selector.isAll()) {
            Fields result2 = fields2[0];
            for (i = 1; i < fields2.length; ++i) {
                result2 = result2.append(fields2[i]);
            }
            return result2;
        }
        if (selector.isReplace()) {
            if (fields2[1].isUnknown()) {
                throw new TupleException("cannot replace fields with unknown field declaration");
            }
            if (!fields2[0].contains(fields2[1])) {
                throw new TupleException("could not find all fields to be replaced, available: " + fields2[0].printVerbose() + ",  declared: " + fields2[1].printVerbose());
            }
            Type[] types2 = fields2[0].getTypes();
            if (types2 != null) {
                for (i = 1; i < fields2.length; ++i) {
                    Type[] fieldTypes = fields2[i].getTypes();
                    if (fieldTypes == null) continue;
                    for (int j = 0; j < fieldTypes.length; ++j) {
                        fields2[0] = fields2[0].applyType(fields2[i].get(j), fieldTypes[j]);
                    }
                }
            }
            return fields2[0];
        }
        if (!selector.isDefined()) {
            throw new TupleException("unable to use given selector: " + selector);
        }
        LinkedHashSet<String> notFound = new LinkedHashSet<String>();
        HashSet<String> found = new HashSet<String>();
        Fields result3 = Fields.size(selector.size());
        if (hasUnknowns) {
            size2 = -1;
        }
        Object[] types3 = null;
        if (size2 != -1) {
            types3 = new Type[result3.size()];
        }
        int offset = 0;
        for (Fields current : fields2) {
            if (current.isNone()) continue;
            Fields.resolveInto(notFound, found, selector, current, result3, (Type[])types3, offset, size2);
            offset += current.size();
        }
        if (types3 != null && !Util.containsNull(types3)) {
            result3 = result3.applyTypes((Type[])types3);
        }
        notFound.removeAll(found);
        if (!notFound.isEmpty()) {
            throw new FieldsResolverException(new Fields(Fields.join(size2, fields2)), new Fields(notFound.toArray(new Comparable[notFound.size()])));
        }
        if (hasUnknowns) {
            return selector;
        }
        return result3;
    }

    private static void resolveInto(Set<String> notFound, Set<String> found, Fields selector, Fields current, Fields result2, Type[] types2, int offset, int size2) {
        for (int i = 0; i < selector.size(); ++i) {
            Comparable field2 = selector.get(i);
            if (field2 instanceof String) {
                int index2 = current.indexOfSafe(field2);
                if (index2 == -1) {
                    notFound.add((String)((Object)field2));
                } else {
                    result2.set(i, Fields.handleFound(found, field2));
                }
                if (index2 == -1 || types2 == null || current.getType(index2) == null) continue;
                types2[i] = current.getType(index2);
                continue;
            }
            int pos = current.translatePos((Integer)field2, size2) - offset;
            if (pos >= current.size() || pos < 0) continue;
            Comparable thisField = current.get(pos);
            if (types2 != null && current.getType(pos) != null) {
                types2[i] = current.getType(pos);
            }
            if (thisField instanceof String) {
                result2.set(i, Fields.handleFound(found, thisField));
                continue;
            }
            result2.set(i, field2);
        }
    }

    private static Comparable handleFound(Set<String> found, Comparable field2) {
        if (found.contains(field2)) {
            throw new TupleException("field name already exists: " + field2);
        }
        found.add((String)((Object)field2));
        return field2;
    }

    public static Fields asDeclaration(Fields fields2) {
        if (fields2 == null) {
            return null;
        }
        if (fields2.isNone()) {
            return fields2;
        }
        if (!fields2.isDefined()) {
            return UNKNOWN;
        }
        if (fields2.isOrdered()) {
            return fields2;
        }
        Fields result2 = Fields.size(fields2.size());
        Fields.copy(null, result2, fields2, 0);
        result2.types = Fields.copyTypes(fields2.types, result2.size());
        result2.comparators = fields2.comparators;
        return result2;
    }

    private static Fields asSelector(Fields fields2) {
        if (!fields2.isDefined()) {
            return UNKNOWN;
        }
        return fields2;
    }

    private Fields() {
    }

    protected Fields(Kind kind) {
        this.kind = kind;
    }

    @ConstructorProperties(value={"fields"})
    public Fields(Comparable ... fields2) {
        if (fields2.length == 0) {
            this.kind = Kind.NONE;
        } else {
            this.fields = this.validate(fields2);
        }
    }

    public Fields(Comparable field2, Type type) {
        this(Fields.names(field2), Fields.types(type));
    }

    public Fields(Comparable[] fields2, Type[] types2) {
        this(fields2);
        if (this.isDefined() && types2 != null) {
            if (this.fields.length != types2.length) {
                throw new IllegalArgumentException("given types array must be same length as fields");
            }
            if (Util.containsNull(types2)) {
                throw new IllegalArgumentException("given types array contains null");
            }
            this.types = Fields.copyTypes(types2, this.fields.length);
        }
    }

    public boolean isUnOrdered() {
        return !this.isOrdered || this.kind == Kind.ALL;
    }

    public boolean isOrdered() {
        return this.isOrdered || this.kind == Kind.UNKNOWN;
    }

    public boolean isDefined() {
        return this.kind == null;
    }

    public boolean isOutSelector() {
        return this.isAll() || this.isResults() || this.isReplace() || this.isSwap() || this.isDefined();
    }

    public boolean isArgSelector() {
        return this.isAll() || this.isNone() || this.isGroup() || this.isValues() || this.isDefined();
    }

    public boolean isDeclarator() {
        return this.isUnknown() || this.isNone() || this.isAll() || this.isArguments() || this.isGroup() || this.isValues() || this.isDefined();
    }

    public boolean isNone() {
        return this.kind == Kind.NONE;
    }

    public boolean isAll() {
        return this.kind == Kind.ALL;
    }

    public boolean isUnknown() {
        return this.kind == Kind.UNKNOWN;
    }

    public boolean isArguments() {
        return this.kind == Kind.ARGS;
    }

    public boolean isValues() {
        return this.kind == Kind.VALUES;
    }

    public boolean isResults() {
        return this.kind == Kind.RESULTS;
    }

    public boolean isReplace() {
        return this.kind == Kind.REPLACE;
    }

    public boolean isSwap() {
        return this.kind == Kind.SWAP;
    }

    public boolean isGroup() {
        return this.kind == Kind.GROUP;
    }

    public boolean isSubstitution() {
        return this.isAll() || this.isArguments() || this.isGroup() || this.isValues();
    }

    private Comparable[] validate(Comparable[] fields2) {
        this.isOrdered = true;
        HashSet<Comparable> names2 = new HashSet<Comparable>();
        for (int i = 0; i < fields2.length; ++i) {
            Comparable field2 = fields2[i];
            if (!(field2 instanceof String) && !(field2 instanceof Integer)) {
                throw new IllegalArgumentException(String.format("invalid field type (%s); must be String or Integer: ", field2));
            }
            if (names2.contains(field2)) {
                throw new IllegalArgumentException("duplicate field name found: " + field2);
            }
            names2.add(field2);
            if (!(field2 instanceof Number) || (Integer)field2 == i) continue;
            this.isOrdered = false;
        }
        return fields2;
    }

    final Comparable[] get() {
        return this.fields;
    }

    public final Comparable get(int i) {
        return this.fields[i];
    }

    final void set(int i, Comparable comparable) {
        this.fields[i] = comparable;
        if (this.isOrdered() && comparable instanceof Integer) {
            this.isOrdered = i == (Integer)comparable;
        }
    }

    public int[] getPos() {
        if (this.thisPos != null) {
            return this.thisPos;
        }
        this.thisPos = this.isAll() || this.isUnknown() ? EMPTY_INT : this.makeThisPos();
        return this.thisPos;
    }

    private int[] makeThisPos() {
        int[] pos = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            Comparable field2 = this.get(i);
            pos[i] = field2 instanceof Number ? (Integer)field2 : i;
        }
        return pos;
    }

    private final Map<Fields, int[]> getPosCache() {
        if (this.posCache == null) {
            this.posCache = new HashMap<Fields, int[]>();
        }
        return this.posCache;
    }

    private final int[] putReturn(Fields fields2, int[] pos) {
        this.getPosCache().put(fields2, pos);
        return pos;
    }

    public final int[] getPos(Fields fields2) {
        return this.getPos(fields2, -1);
    }

    final int[] getPos(Fields fields2, int tupleSize) {
        if (!this.isUnknown() && this.getPosCache().containsKey(fields2)) {
            return this.getPosCache().get(fields2);
        }
        if (fields2.isAll()) {
            return this.putReturn(fields2, null);
        }
        if (this.isAll()) {
            return this.putReturn(fields2, fields2.getPos());
        }
        if (this.size() == 0 && this.isUnknown()) {
            return this.translatePos(fields2, tupleSize);
        }
        int[] pos = this.translatePos(fields2, this.size());
        return this.putReturn(fields2, pos);
    }

    private int[] translatePos(Fields fields2, int fieldSize) {
        int[] pos = new int[fields2.size()];
        for (int i = 0; i < fields2.size(); ++i) {
            Comparable field2 = fields2.get(i);
            pos[i] = field2 instanceof Number ? this.translatePos((Integer)field2, fieldSize) : this.indexOf(field2);
        }
        return pos;
    }

    final int translatePos(Integer integer) {
        return this.translatePos(integer, this.size());
    }

    final int translatePos(Integer integer, int size2) {
        if (size2 == -1) {
            return integer;
        }
        if (integer < 0) {
            integer = size2 + integer;
        }
        if (!(this.isUnknown() || integer < size2 && integer >= 0)) {
            throw new TupleException("position value is too large: " + integer + ", positions in field: " + size2);
        }
        return integer;
    }

    public int getPos(Comparable fieldName) {
        if (fieldName instanceof Number) {
            return this.translatePos((Integer)fieldName);
        }
        return this.indexOf(fieldName);
    }

    private final Map<Comparable, Integer> getIndex() {
        if (this.index != null) {
            return this.index;
        }
        HashMap<Comparable, Integer> local = new HashMap<Comparable, Integer>();
        for (int i = 0; i < this.size(); ++i) {
            local.put(this.get(i), i);
        }
        this.index = local;
        return this.index;
    }

    private int indexOf(Comparable fieldName) {
        Integer result2 = this.getIndex().get(fieldName);
        if (result2 == null) {
            throw new FieldsResolverException(this, new Fields(fieldName));
        }
        return result2;
    }

    int indexOfSafe(Comparable fieldName) {
        Integer result2 = this.getIndex().get(fieldName);
        if (result2 == null) {
            return -1;
        }
        return result2;
    }

    @Override
    public Iterator iterator() {
        return Collections.unmodifiableList(Arrays.asList(this.fields)).iterator();
    }

    public Fields select(Fields selector) {
        Comparable field2;
        int i;
        if (!this.isOrdered()) {
            throw new TupleException("this fields instance can only be used as a selector");
        }
        if (selector.isAll()) {
            return this;
        }
        if (this.isUnknown()) {
            return Fields.asSelector(selector);
        }
        if (selector.isNone()) {
            return NONE;
        }
        Fields result2 = Fields.size(selector.size());
        for (i = 0; i < selector.size(); ++i) {
            field2 = selector.get(i);
            if (field2 instanceof String) {
                result2.set(i, this.get(this.indexOf(field2)));
                continue;
            }
            int pos = this.translatePos((Integer)field2);
            if (this.get(pos) instanceof String) {
                result2.set(i, this.get(pos));
                continue;
            }
            result2.set(i, Integer.valueOf(pos));
        }
        if (this.types != null) {
            result2.types = new Type[result2.size()];
            for (i = 0; i < selector.size(); ++i) {
                field2 = selector.get(i);
                if (field2 instanceof String) {
                    result2.setType(i, this.getType(this.indexOf(field2)));
                    continue;
                }
                result2.setType(i, this.getType(this.translatePos((Integer)field2)));
            }
        }
        return result2;
    }

    public Fields selectPos(Fields selector) {
        return this.selectPos(selector, 0);
    }

    public Fields selectPos(Fields selector, int offset) {
        int[] pos = this.getPos(selector);
        Fields results2 = Fields.size(pos.length);
        for (int i = 0; i < pos.length; ++i) {
            results2.fields[i] = Integer.valueOf(pos[i] + offset);
        }
        return results2;
    }

    public Fields subtract(Fields fields2) {
        int[] pos;
        if (fields2.isAll()) {
            return NONE;
        }
        if (fields2.isNone()) {
            return this;
        }
        LinkedList list2 = new LinkedList();
        Collections.addAll(list2, this.get());
        for (int i : pos = this.getPos(fields2, -1)) {
            list2.set(i, null);
        }
        Util.removeAllNulls(list2);
        Type[] newTypes = null;
        if (this.types != null) {
            LinkedList types2 = new LinkedList();
            Collections.addAll(types2, this.types);
            for (int i : pos) {
                types2.set(i, null);
            }
            Util.removeAllNulls(types2);
            newTypes = types2.toArray(new Type[types2.size()]);
        }
        return new Fields(list2.toArray(new Comparable[list2.size()]), newTypes);
    }

    @Deprecated
    public Fields append(Fields[] fields2) {
        if (fields2.length == 0) {
            return null;
        }
        Fields field2 = this;
        for (Fields current : fields2) {
            field2 = field2.append(current);
        }
        return field2;
    }

    public Fields append(Fields fields2) {
        return this.appendInternal(fields2, false);
    }

    public Fields appendSelector(Fields fields2) {
        return this.appendInternal(fields2, true);
    }

    private Fields appendInternal(Fields fields2, boolean isSelect) {
        if (fields2 == null) {
            return this;
        }
        if (this.isAll() || fields2.isAll()) {
            throw new TupleException("cannot append fields: " + this.print() + " + " + fields2.print());
        }
        if ((this.isUnknown() || this.size() == 0) && fields2.isUnknown()) {
            return UNKNOWN;
        }
        if (fields2.isNone()) {
            return this;
        }
        if (this.isNone()) {
            return fields2;
        }
        HashSet<Comparable> names2 = new HashSet<Comparable>();
        Fields result2 = Fields.size(this.size() + fields2.size());
        Fields.copyRetain(names2, result2, this, 0, isSelect);
        Fields.copyRetain(names2, result2, fields2, this.size(), isSelect);
        if (this.isUnknown() || fields2.isUnknown()) {
            result2.kind = Kind.UNKNOWN;
        }
        if ((this.isNone() || this.types != null) && fields2.types != null) {
            result2.types = new Type[this.size() + fields2.size()];
            if (this.types != null) {
                System.arraycopy(this.types, 0, result2.types, 0, this.size());
            }
            System.arraycopy(fields2.types, 0, result2.types, this.size(), fields2.size());
        }
        return result2;
    }

    public Fields rename(Fields from2, Fields to2) {
        if (this.isSubstitution() || this.isUnknown()) {
            throw new TupleException("cannot rename fields in a substitution or unknown Fields instance: " + this.print());
        }
        if (from2.size() != to2.size()) {
            throw new TupleException("from and to fields must be the same size");
        }
        if (from2.isSubstitution() || from2.isUnknown()) {
            throw new TupleException("from fields may not be a substitution or unknown");
        }
        if (to2.isSubstitution() || to2.isUnknown()) {
            throw new TupleException("to fields may not be a substitution or unknown");
        }
        Comparable[] newFields = Arrays.copyOf(this.fields, this.fields.length);
        int[] pos = this.getPos(from2);
        for (int i = 0; i < pos.length; ++i) {
            newFields[pos[i]] = to2.fields[i];
        }
        Type[] newTypes = null;
        if (this.types != null && to2.types != null) {
            newTypes = Fields.copyTypes(this.types, this.size());
            for (int i = 0; i < pos.length; ++i) {
                newTypes[pos[i]] = to2.types[i];
            }
        }
        return new Fields(newFields, newTypes);
    }

    public Fields project(Fields fields2) {
        if (fields2 == null) {
            return this;
        }
        Fields results2 = Fields.size(fields2.size()).applyTypes(fields2.getTypes());
        for (int i = 0; i < fields2.fields.length; ++i) {
            results2.fields[i] = fields2.fields[i] instanceof String ? fields2.fields[i] : (this.fields[i] instanceof String ? this.fields[i] : Integer.valueOf(i));
        }
        return results2;
    }

    private static void copy(Set<String> names2, Fields result2, Fields fields2, int offset) {
        for (int i = 0; i < fields2.size(); ++i) {
            Comparable field2 = fields2.get(i);
            if (!(field2 instanceof String)) continue;
            if (names2 != null) {
                if (names2.contains(field2)) {
                    throw new TupleException("field name already exists: " + field2);
                }
                names2.add((String)((Object)field2));
            }
            result2.set(i + offset, field2);
        }
    }

    private static void copyRetain(Set<Comparable> names2, Fields result2, Fields fields2, int offset, boolean isSelect) {
        for (int i = 0; i < fields2.size(); ++i) {
            Comparable field2 = fields2.get(i);
            if (!isSelect && field2 instanceof Integer) continue;
            if (names2 != null) {
                if (names2.contains(field2)) {
                    throw new TupleException("field name already exists: " + field2);
                }
                names2.add(field2);
            }
            result2.set(i + offset, field2);
        }
    }

    public void verifyContains(Fields fields2) {
        if (this.isUnknown()) {
            return;
        }
        try {
            this.getPos(fields2);
        }
        catch (TupleException exception) {
            throw new TupleException("these fields " + this.print() + ", do not contain " + fields2.print());
        }
    }

    public boolean contains(Fields fields2) {
        try {
            this.getPos(fields2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int compareTo(Fields other) {
        if (other.size() != this.size()) {
            return other.size() < this.size() ? 1 : -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            int c = this.get(i).compareTo(other.get(i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public int compareTo(Object other) {
        if (other instanceof Fields) {
            return this.compareTo((Fields)other);
        }
        return -1;
    }

    public String print() {
        return "[" + this.toString() + "]";
    }

    public String printVerbose() {
        String fieldsString = this.toString();
        return "[{" + (this.isDefined() ? Integer.valueOf(this.size()) : "?") + "}:" + fieldsString + "]";
    }

    public String toString() {
        String string2 = this.isOrdered() ? this.orderedToString() : this.unorderedToString();
        if (this.types != null) {
            string2 = string2 + " | " + Util.join(Util.simpleTypeNames(this.types), ", ");
        }
        return string2;
    }

    private String orderedToString() {
        StringBuffer buffer2 = new StringBuffer();
        if (this.size() != 0) {
            int startIndex = this.get(0) instanceof Number ? (Integer)this.get(0) : 0;
            for (int i = 0; i < this.size(); ++i) {
                Comparable field2 = this.get(i);
                if (field2 instanceof Number) {
                    if (i + 1 != this.size() && this.get(i + 1) instanceof Number) continue;
                    if (buffer2.length() != 0) {
                        buffer2.append(", ");
                    }
                    if (startIndex != i) {
                        buffer2.append(startIndex).append(":").append(field2);
                    } else {
                        buffer2.append(i);
                    }
                    startIndex = i;
                    continue;
                }
                if (i != 0) {
                    buffer2.append(", ");
                }
                if (field2 instanceof String) {
                    buffer2.append("'").append(field2).append("'");
                } else if (field2 instanceof Fields) {
                    buffer2.append(((Fields)field2).print());
                }
                startIndex = i + 1;
            }
        }
        if (this.kind != null) {
            if (buffer2.length() != 0) {
                buffer2.append(", ");
            }
            buffer2.append((Object)this.kind);
        }
        return buffer2.toString();
    }

    private String unorderedToString() {
        StringBuffer buffer2 = new StringBuffer();
        for (Comparable field2 : this.get()) {
            if (buffer2.length() != 0) {
                buffer2.append(", ");
            }
            if (field2 instanceof String) {
                buffer2.append("'").append(field2).append("'");
                continue;
            }
            if (field2 instanceof Fields) {
                buffer2.append(((Fields)field2).print());
                continue;
            }
            buffer2.append(field2);
        }
        if (this.kind != null) {
            if (buffer2.length() != 0) {
                buffer2.append(", ");
            }
            buffer2.append((Object)this.kind);
        }
        return buffer2.toString();
    }

    public final int size() {
        return this.fields.length;
    }

    public Fields applyType(Comparable fieldName, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("given type must not be null");
        }
        try {
            int pos = this.getPos(Fields.asFieldName(fieldName));
        }
        catch (FieldsResolverException exception) {
            throw new IllegalArgumentException("given field name was not found: " + fieldName, exception);
        }
        Fields results2 = new Fields(this.fields);
        results2.types = this.types == null ? new Type[this.size()] : this.types;
        results2.types[pos] = type;
        return results2;
    }

    public Fields applyTypes(Fields fields2) {
        Fields result2 = new Fields(this.fields, this.types);
        for (Comparable field2 : fields2) {
            result2 = result2.applyType(field2, fields2.getType(fields2.getPos(field2)));
        }
        return result2;
    }

    public Fields applyTypes(Type ... types2) {
        Fields result2 = new Fields(this.fields);
        if (types2 == null) {
            return result2;
        }
        if (types2.length != this.size()) {
            throw new IllegalArgumentException("given number of class instances must match fields size");
        }
        for (Type type : types2) {
            if (type != null) continue;
            throw new IllegalArgumentException("type must not be null");
        }
        result2.types = Fields.copyTypes(types2, types2.length);
        return result2;
    }

    public Type getType(Comparable fieldName) {
        if (!this.hasTypes()) {
            return null;
        }
        return this.getType(this.getPos(fieldName));
    }

    public Type getType(int pos) {
        if (!this.hasTypes()) {
            return null;
        }
        return this.types[pos];
    }

    public Class getTypeClass(Comparable fieldName) {
        if (!this.hasTypes()) {
            return null;
        }
        return this.getTypeClass(this.getPos(fieldName));
    }

    public Class getTypeClass(int pos) {
        Type type = this.getType(pos);
        if (type instanceof CoercibleType) {
            return ((CoercibleType)type).getCanonicalType();
        }
        return (Class)type;
    }

    protected void setType(int pos, Type type) {
        if (type == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        this.types[pos] = type;
    }

    public Type[] getTypes() {
        return Fields.copyTypes(this.types, this.size());
    }

    public Class[] getTypesClasses() {
        if (this.types == null) {
            return null;
        }
        Class[] classes2 = new Class[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            classes2[i] = this.types[i] instanceof CoercibleType ? ((CoercibleType)this.types[i]).getCanonicalType() : (Class)this.types[i];
        }
        return classes2;
    }

    private static Type[] copyTypes(Type[] types2, int size2) {
        if (types2 == null) {
            return null;
        }
        Type[] copy = new Type[size2];
        if (types2.length != size2) {
            throw new IllegalArgumentException("types array must be same size as fields array");
        }
        System.arraycopy(types2, 0, copy, 0, size2);
        return copy;
    }

    public final boolean hasTypes() {
        return this.types != null;
    }

    public void setComparator(Comparable fieldName, Comparator comparator) {
        if (!(comparator instanceof Serializable)) {
            throw new IllegalArgumentException("given comparator must be serializable");
        }
        if (this.comparators == null) {
            this.comparators = new Comparator[this.size()];
        }
        try {
            this.comparators[this.getPos((Comparable)Fields.asFieldName((Comparable)fieldName))] = comparator;
        }
        catch (FieldsResolverException exception) {
            throw new IllegalArgumentException("given field name was not found: " + fieldName, exception);
        }
    }

    public void setComparators(Comparator ... comparators) {
        if (comparators.length != this.size()) {
            throw new IllegalArgumentException("given number of comparator instances must match fields size");
        }
        for (Comparator comparator : comparators) {
            if (comparator instanceof Serializable) continue;
            throw new IllegalArgumentException("comparators must be serializable");
        }
        this.comparators = comparators;
    }

    protected static Comparable asFieldName(Comparable fieldName) {
        if (fieldName instanceof Fields) {
            Fields fields2 = (Fields)fieldName;
            if (!fields2.isDefined()) {
                throw new TupleException("given Fields instance must explicitly declare one field name or position: " + fields2.printVerbose());
            }
            fieldName = fields2.get(0);
        }
        return fieldName;
    }

    protected Comparator getComparator(Comparable fieldName) {
        if (this.comparators == null) {
            return null;
        }
        try {
            return this.comparators[this.getPos(Fields.asFieldName(fieldName))];
        }
        catch (FieldsResolverException exception) {
            return null;
        }
    }

    public Comparator[] getComparators() {
        Comparator[] copy = new Comparator[this.size()];
        if (this.comparators != null) {
            System.arraycopy(this.comparators, 0, copy, 0, this.size());
        }
        return copy;
    }

    public boolean hasComparators() {
        return this.comparators != null;
    }

    @Override
    public int compare(Tuple lhs, Tuple rhs) {
        return lhs.compareTo(this.comparators, rhs);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Fields fields2 = (Fields)object;
        return this.equalsFields(fields2) && Arrays.equals(this.types, fields2.types);
    }

    public boolean equalsFields(Fields fields2) {
        return fields2 != null && this.kind == fields2.kind && Arrays.equals(this.get(), fields2.get());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.get() != null ? Arrays.hashCode(this.get()) : 0;
        }
        return this.hashCode;
    }

    static enum Kind {
        NONE,
        ALL,
        GROUP,
        VALUES,
        ARGS,
        RESULTS,
        UNKNOWN,
        REPLACE,
        SWAP;

    }
}

