/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.partition;

import cascading.tap.TapException;
import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntrySchemeIterator;
import cascading.tuple.util.TupleViews;
import java.util.Iterator;

public class PartitionTupleEntryIterator
implements Iterator<Tuple> {
    private final TupleEntrySchemeIterator childIterator;
    private final Tuple base;
    private final Tuple view;

    public PartitionTupleEntryIterator(Fields sourceFields2, Partition partition2, String parentIdentifier, String childIdentifier, TupleEntrySchemeIterator schemeIterator) {
        this.childIterator = schemeIterator;
        TupleEntry partitionEntry = new TupleEntry(partition2.getPartitionFields(), Tuple.size(partition2.getPartitionFields().size()));
        try {
            partition2.toTuple(childIdentifier.substring(parentIdentifier.length() + 1), partitionEntry);
        }
        catch (Exception exception) {
            throw new TapException("unable to parse partition given parent: " + parentIdentifier + " and child: " + childIdentifier);
        }
        this.base = TupleViews.createOverride(sourceFields2, partitionEntry.getFields());
        TupleViews.reset(this.base, Tuple.size(sourceFields2.size()), partitionEntry.getTuple());
        this.view = TupleViews.createOverride(sourceFields2, this.childIterator.getFields());
    }

    @Override
    public boolean hasNext() {
        return this.childIterator.hasNext();
    }

    @Override
    public Tuple next() {
        Tuple tuple = this.childIterator.next().getTuple();
        TupleViews.reset(this.view, this.base, tuple);
        return this.view;
    }

    @Override
    public void remove() {
        this.childIterator.remove();
    }
}

