/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.partition;

import cascading.tap.partition.Partition;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.util.Util;
import java.util.regex.Pattern;

public class DelimitedPartition
implements Partition {
    public static final String PATH_DELIM = "/";
    Fields partitionFields;
    String delimiter = "/";
    transient Pattern pattern;

    public DelimitedPartition(Fields partitionFields, String delimiter) {
        this(partitionFields);
        this.delimiter = delimiter;
    }

    public DelimitedPartition(Fields partitionFields) {
        if (partitionFields == null) {
            throw new IllegalArgumentException("partitionFields must not be null");
        }
        if (!partitionFields.isDefined()) {
            throw new IllegalArgumentException("partitionFields must be defined, got: " + partitionFields.printVerbose());
        }
        this.partitionFields = partitionFields;
    }

    @Override
    public int getPathDepth() {
        return this.partitionFields.size();
    }

    @Override
    public Fields getPartitionFields() {
        return this.partitionFields;
    }

    protected Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.delimiter);
        }
        return this.pattern;
    }

    @Override
    public void toTuple(String partition2, TupleEntry tupleEntry) {
        if (partition2.startsWith(this.delimiter)) {
            partition2 = partition2.substring(1);
        }
        Object[] split2 = this.getPattern().split(partition2);
        tupleEntry.setCanonicalValues(split2);
    }

    @Override
    public String toPartition(TupleEntry tupleEntry) {
        return Util.join(tupleEntry.asIterableOf(String.class), this.delimiter, true);
    }
}

