/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.partition;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.partition.Partition;
import cascading.tap.partition.PartitionTupleEntryIterator;
import cascading.tap.type.FileType;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterableChainIterator;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleEntrySchemeCollector;
import cascading.tuple.TupleEntrySchemeIterator;
import cascading.tuple.util.TupleViews;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePartitionTap<Config, Input, Output>
extends Tap<Config, Input, Output> {
    private static final Logger LOG = LoggerFactory.getLogger(BasePartitionTap.class);
    protected static final int OPEN_WRITES_THRESHOLD_DEFAULT = 300;
    protected Tap parent;
    protected Partition partition;
    protected boolean keepParentOnDelete = false;
    protected int openWritesThreshold = 300;
    private long openedCollectors = 0L;
    private final Map<String, TupleEntryCollector> collectors = new LinkedHashMap<String, TupleEntryCollector>(1000, 0.75f, true);

    protected abstract TupleEntrySchemeCollector createTupleEntrySchemeCollector(FlowProcess<Config> var1, Tap var2, String var3, long var4) throws IOException;

    protected abstract TupleEntrySchemeIterator createTupleEntrySchemeIterator(FlowProcess<Config> var1, Tap var2, String var3, Input var4) throws IOException;

    protected BasePartitionTap(Tap parent, Partition partition2, int openWritesThreshold) {
        super(new PartitionScheme(parent.getScheme(), partition2.getPartitionFields()), parent.getSinkMode());
        this.parent = parent;
        this.partition = partition2;
        this.openWritesThreshold = openWritesThreshold;
    }

    protected BasePartitionTap(Tap parent, Partition partition2, SinkMode sinkMode) {
        super(new PartitionScheme(parent.getScheme(), partition2.getPartitionFields()), sinkMode);
        this.parent = parent;
        this.partition = partition2;
    }

    protected BasePartitionTap(Tap parent, Partition partition2, SinkMode sinkMode, boolean keepParentOnDelete, int openWritesThreshold) {
        super(new PartitionScheme(parent.getScheme(), partition2.getPartitionFields()), sinkMode);
        this.parent = parent;
        this.partition = partition2;
        this.keepParentOnDelete = keepParentOnDelete;
        this.openWritesThreshold = openWritesThreshold;
    }

    public Tap getParent() {
        return this.parent;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public String[] getChildPartitionIdentifiers(FlowProcess<Config> flowProcess, boolean fullyQualified) throws IOException {
        return ((FileType)((Object)this.parent)).getChildIdentifiers(flowProcess.getConfigCopy(), this.partition.getPathDepth(), fullyQualified);
    }

    @Override
    public String getIdentifier() {
        return this.parent.getIdentifier();
    }

    protected abstract String getCurrentIdentifier(FlowProcess<Config> var1);

    public int getOpenWritesThreshold() {
        return this.openWritesThreshold;
    }

    @Override
    public TupleEntryCollector openForWrite(FlowProcess<Config> flowProcess, Output output) throws IOException {
        return new PartitionCollector(flowProcess);
    }

    @Override
    public TupleEntryIterator openForRead(FlowProcess<Config> flowProcess, Input input2) throws IOException {
        return new PartitionIterator(flowProcess, input2);
    }

    @Override
    public boolean createResource(Config conf) throws IOException {
        return this.parent.createResource(conf);
    }

    @Override
    public boolean deleteResource(Config conf) throws IOException {
        return this.keepParentOnDelete || this.parent.deleteResource(conf);
    }

    @Override
    public boolean commitResource(Config conf) throws IOException {
        return this.parent.commitResource(conf);
    }

    @Override
    public boolean rollbackResource(Config conf) throws IOException {
        return this.parent.rollbackResource(conf);
    }

    @Override
    public boolean resourceExists(Config conf) throws IOException {
        return this.parent.resourceExists(conf);
    }

    @Override
    public long getModifiedTime(Config conf) throws IOException {
        return this.parent.getModifiedTime(conf);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        BasePartitionTap that = (BasePartitionTap)object;
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return !(this.partition != null ? !this.partition.equals(that.partition) : that.partition != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.parent != null ? this.parent.hashCode() : 0);
        result2 = 31 * result2 + (this.partition != null ? this.partition.hashCode() : 0);
        return result2;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[\"" + this.parent + "\"]" + "[\"" + this.partition + "\"]";
    }

    public static class PartitionScheme<Config, Input, Output>
    extends Scheme<Config, Input, Output, Void, Void> {
        private final Scheme scheme;
        private final Fields partitionFields;

        public PartitionScheme(Scheme scheme) {
            this.scheme = scheme;
            this.partitionFields = null;
        }

        public PartitionScheme(Scheme scheme, Fields partitionFields) {
            this.scheme = scheme;
            if (partitionFields == null || partitionFields.isAll()) {
                this.partitionFields = null;
            } else if (partitionFields.isDefined()) {
                this.partitionFields = partitionFields;
            } else {
                throw new IllegalArgumentException("partitionFields must be defined or the ALL substitution, got: " + partitionFields.printVerbose());
            }
        }

        @Override
        public Fields getSinkFields() {
            if (this.partitionFields == null || this.scheme.getSinkFields().isAll()) {
                return this.scheme.getSinkFields();
            }
            return Fields.merge(this.scheme.getSinkFields(), this.partitionFields);
        }

        @Override
        public void setSinkFields(Fields sinkFields2) {
            this.scheme.setSinkFields(sinkFields2);
        }

        @Override
        public Fields getSourceFields() {
            if (this.partitionFields == null || this.scheme.getSourceFields().isUnknown()) {
                return this.scheme.getSourceFields();
            }
            return Fields.merge(this.scheme.getSourceFields(), this.partitionFields);
        }

        @Override
        public void setSourceFields(Fields sourceFields2) {
            this.scheme.setSourceFields(sourceFields2);
        }

        @Override
        public int getNumSinkParts() {
            return this.scheme.getNumSinkParts();
        }

        @Override
        public void setNumSinkParts(int numSinkParts) {
            this.scheme.setNumSinkParts(numSinkParts);
        }

        @Override
        public void sourceConfInit(FlowProcess<Config> flowProcess, Tap<Config, Input, Output> tap, Config conf) {
            this.scheme.sourceConfInit(flowProcess, tap, conf);
        }

        @Override
        public void sourcePrepare(FlowProcess<Config> flowProcess, SourceCall<Void, Input> sourceCall) throws IOException {
            this.scheme.sourcePrepare(flowProcess, sourceCall);
        }

        @Override
        public boolean source(FlowProcess<Config> flowProcess, SourceCall<Void, Input> sourceCall) throws IOException {
            throw new UnsupportedOperationException("should never be called");
        }

        @Override
        public void sourceCleanup(FlowProcess<Config> flowProcess, SourceCall<Void, Input> sourceCall) throws IOException {
            this.scheme.sourceCleanup(flowProcess, sourceCall);
        }

        @Override
        public void sinkConfInit(FlowProcess<Config> flowProcess, Tap<Config, Input, Output> tap, Config conf) {
            this.scheme.sinkConfInit(flowProcess, tap, conf);
        }

        @Override
        public void sinkPrepare(FlowProcess<Config> flowProcess, SinkCall<Void, Output> sinkCall) throws IOException {
            this.scheme.sinkPrepare(flowProcess, sinkCall);
        }

        @Override
        public void sink(FlowProcess<Config> flowProcess, SinkCall<Void, Output> sinkCall) throws IOException {
            throw new UnsupportedOperationException("should never be called");
        }

        @Override
        public void sinkCleanup(FlowProcess<Config> flowProcess, SinkCall<Void, Output> sinkCall) throws IOException {
            this.scheme.sinkCleanup(flowProcess, sinkCall);
        }
    }

    public static enum Counters {
        Paths_Opened,
        Paths_Closed,
        Path_Purges;

    }

    public class PartitionCollector
    extends TupleEntryCollector {
        private final FlowProcess<Config> flowProcess;
        private final Config conf;
        private final Fields parentFields;
        private final Fields partitionFields;
        private TupleEntry partitionEntry;
        private final Tuple partitionTuple;
        private final Tuple parentTuple;

        public PartitionCollector(FlowProcess<Config> flowProcess) {
            super(Fields.asDeclaration(BasePartitionTap.this.getSinkFields()));
            this.flowProcess = flowProcess;
            this.conf = flowProcess.getConfigCopy();
            this.parentFields = BasePartitionTap.this.parent.getSinkFields();
            this.partitionFields = ((PartitionScheme)BasePartitionTap.this.getScheme()).partitionFields;
            this.partitionEntry = new TupleEntry(this.partitionFields);
            this.partitionTuple = TupleViews.createNarrow(BasePartitionTap.this.getSinkFields().getPos(this.partitionFields));
            this.parentTuple = TupleViews.createNarrow(BasePartitionTap.this.getSinkFields().getPos(this.parentFields));
            this.partitionEntry.setTuple(this.partitionTuple);
        }

        TupleEntryCollector getCollector(String path) {
            TupleEntryCollector collector = (TupleEntryCollector)BasePartitionTap.this.collectors.get(path);
            if (collector != null) {
                return collector;
            }
            try {
                LOG.debug("creating collector for parent: {}, path: {}", (Object)BasePartitionTap.this.parent.getFullIdentifier(this.conf), (Object)path);
                collector = BasePartitionTap.this.createTupleEntrySchemeCollector(this.flowProcess, BasePartitionTap.this.parent, path, BasePartitionTap.this.openedCollectors);
                BasePartitionTap.this.openedCollectors++;
                this.flowProcess.increment(Counters.Paths_Opened, 1L);
            }
            catch (IOException exception) {
                throw new TapException("unable to open partition path: " + path, exception);
            }
            if (BasePartitionTap.this.collectors.size() > BasePartitionTap.this.openWritesThreshold) {
                this.purgeCollectors();
            }
            BasePartitionTap.this.collectors.put(path, collector);
            if (LOG.isInfoEnabled() && BasePartitionTap.this.collectors.size() % 100 == 0) {
                LOG.info("caching {} open Taps", (Object)BasePartitionTap.this.collectors.size());
            }
            return collector;
        }

        private void purgeCollectors() {
            int numToClose = Math.max(1, (int)((double)BasePartitionTap.this.openWritesThreshold * 0.1));
            if (LOG.isInfoEnabled()) {
                LOG.info("removing {} open Taps from cache of size {}", (Object)numToClose, (Object)BasePartitionTap.this.collectors.size());
            }
            HashSet<String> removeKeys = new HashSet<String>();
            Set keys2 = BasePartitionTap.this.collectors.keySet();
            for (String key : keys2) {
                if (numToClose-- == 0) break;
                removeKeys.add(key);
            }
            for (String removeKey : removeKeys) {
                this.closeCollector(removeKey);
                BasePartitionTap.this.collectors.remove(removeKey);
            }
            this.flowProcess.increment(Counters.Path_Purges, 1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            super.close();
            try {
                for (String path : new ArrayList(BasePartitionTap.this.collectors.keySet())) {
                    this.closeCollector(path);
                }
            }
            finally {
                BasePartitionTap.this.collectors.clear();
            }
        }

        public void closeCollector(String path) {
            block4: {
                TupleEntryCollector collector = (TupleEntryCollector)BasePartitionTap.this.collectors.get(path);
                if (collector == null) {
                    return;
                }
                try {
                    collector.close();
                    this.flowProcess.increment(Counters.Paths_Closed, 1L);
                }
                catch (Exception exception) {
                    LOG.error("exception while closing TupleEntryCollector {}", (Object)path, (Object)exception);
                    boolean failOnError = false;
                    Object failProperty = this.flowProcess.getProperty("cascading.tap.partition.failonclose");
                    if (failProperty != null) {
                        failOnError = Boolean.parseBoolean(failProperty.toString());
                    }
                    if (!failOnError) break block4;
                    throw new TapException(exception);
                }
            }
        }

        @Override
        protected void collect(TupleEntry tupleEntry) throws IOException {
            TupleViews.reset(this.partitionTuple, tupleEntry.getTuple());
            TupleViews.reset(this.parentTuple, tupleEntry.getTuple());
            String path = BasePartitionTap.this.partition.toPartition(this.partitionEntry);
            this.getCollector(path).add(this.parentTuple);
        }
    }

    private class PartitionIterator
    extends TupleEntryIterableChainIterator {
        public PartitionIterator(FlowProcess<Config> flowProcess, Input input2) throws IOException {
            super(BasePartitionTap.this.getSourceFields());
            ArrayList<Iterator<Tuple>> iterators = new ArrayList<Iterator<Tuple>>();
            if (input2 != null) {
                String identifier2 = BasePartitionTap.this.parent.getFullIdentifier(flowProcess);
                iterators.add(this.createPartitionEntryIterator(flowProcess, input2, identifier2, BasePartitionTap.this.getCurrentIdentifier(flowProcess)));
            } else {
                String[] childIdentifiers;
                for (String childIdentifier : childIdentifiers = BasePartitionTap.this.getChildPartitionIdentifiers(flowProcess, false)) {
                    iterators.add(this.createPartitionEntryIterator(flowProcess, null, BasePartitionTap.this.parent.getIdentifier(), childIdentifier));
                }
            }
            this.reset(iterators);
        }

        private PartitionTupleEntryIterator createPartitionEntryIterator(FlowProcess<Config> flowProcess, Input input2, String parentIdentifier, String childIdentifier) throws IOException {
            TupleEntrySchemeIterator schemeIterator = BasePartitionTap.this.createTupleEntrySchemeIterator(flowProcess, BasePartitionTap.this.parent, childIdentifier, input2);
            return new PartitionTupleEntryIterator(BasePartitionTap.this.getSourceFields(), BasePartitionTap.this.partition, parentIdentifier, childIdentifier, schemeIterator);
        }
    }
}

