/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.local.io;

import cascading.tap.Tap;
import cascading.tap.TapException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

public class TapFileOutputStream
extends FileOutputStream {
    public TapFileOutputStream(String path, boolean append2) throws FileNotFoundException {
        super(TapFileOutputStream.prepare(null, path), append2);
    }

    public TapFileOutputStream(Tap parent, String path, boolean update2) throws FileNotFoundException {
        super(TapFileOutputStream.prepare(parent, path), update2);
    }

    private static String prepare(Tap parent, String path) {
        File file = parent == null ? new File(path) : new File(parent.getIdentifier(), path);
        File parentFile = file.getAbsoluteFile().getParentFile();
        if (parentFile != null && parentFile.exists() && parentFile.isFile()) {
            throw new TapException("cannot create parent directory, it already exists as a file: " + parentFile.getAbsolutePath());
        }
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        return file.getAbsolutePath();
    }
}

