/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.local;

import cascading.flow.FlowProcess;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.local.FileTap;
import cascading.tap.local.io.TapFileOutputStream;
import cascading.tap.partition.BasePartitionTap;
import cascading.tap.partition.Partition;
import cascading.tuple.TupleEntrySchemeCollector;
import cascading.tuple.TupleEntrySchemeIterator;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class PartitionTap
extends BasePartitionTap<Properties, InputStream, OutputStream> {
    @ConstructorProperties(value={"parent", "partition"})
    public PartitionTap(FileTap parent, Partition partition2) {
        this(parent, partition2, 300);
    }

    @ConstructorProperties(value={"parent", "partition", "openWritesThreshold"})
    public PartitionTap(FileTap parent, Partition partition2, int openWritesThreshold) {
        super((Tap)parent, partition2, openWritesThreshold);
    }

    @ConstructorProperties(value={"parent", "partition", "sinkMode"})
    public PartitionTap(FileTap parent, Partition partition2, SinkMode sinkMode) {
        super((Tap)parent, partition2, sinkMode);
    }

    @ConstructorProperties(value={"parent", "partition", "sinkMode", "keepParentOnDelete"})
    public PartitionTap(FileTap parent, Partition partition2, SinkMode sinkMode, boolean keepParentOnDelete) {
        this(parent, partition2, sinkMode, keepParentOnDelete, 300);
    }

    @ConstructorProperties(value={"parent", "partition", "sinkMode", "keepParentOnDelete", "openWritesThreshold"})
    public PartitionTap(FileTap parent, Partition partition2, SinkMode sinkMode, boolean keepParentOnDelete, int openWritesThreshold) {
        super(parent, partition2, sinkMode, keepParentOnDelete, openWritesThreshold);
    }

    @Override
    protected String getCurrentIdentifier(FlowProcess<Properties> flowProcess) {
        return null;
    }

    @Override
    public boolean deleteResource(Properties conf) throws IOException {
        String[] childIdentifiers = ((FileTap)this.parent).getChildIdentifiers(conf, Integer.MAX_VALUE, false);
        if (childIdentifiers.length == 0) {
            return true;
        }
        boolean result2 = false;
        for (String childIdentifier : childIdentifiers) {
            result2 |= new File(childIdentifier).delete();
        }
        return result2;
    }

    @Override
    protected TupleEntrySchemeCollector createTupleEntrySchemeCollector(FlowProcess<Properties> flowProcess, Tap parent, String path, long sequence2) throws IOException {
        TapFileOutputStream output = new TapFileOutputStream(parent, path, true);
        return new TupleEntrySchemeCollector<Properties, TapFileOutputStream>(flowProcess, parent, output);
    }

    @Override
    protected TupleEntrySchemeIterator createTupleEntrySchemeIterator(FlowProcess<Properties> flowProcess, Tap parent, String path, InputStream input2) throws FileNotFoundException {
        if (input2 == null) {
            input2 = new FileInputStream(path);
        }
        return new TupleEntrySchemeIterator<Properties, InputStream>(flowProcess, parent.getScheme(), input2, path);
    }
}

