/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.local;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.local.io.TapFileOutputStream;
import cascading.tap.type.FileType;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.TupleEntrySchemeCollector;
import cascading.tuple.TupleEntrySchemeIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public class FileTap
extends Tap<Properties, InputStream, OutputStream>
implements FileType<Properties> {
    private final String path;

    public FileTap(Scheme<Properties, InputStream, OutputStream, ?, ?> scheme, String path) {
        this(scheme, path, SinkMode.KEEP);
    }

    public FileTap(Scheme<Properties, InputStream, OutputStream, ?, ?> scheme, String path, SinkMode sinkMode) {
        super(scheme, sinkMode);
        this.path = new File(path).getPath();
    }

    @Override
    public String getIdentifier() {
        return this.path;
    }

    @Override
    public String getFullIdentifier(Properties conf) {
        return this.fullyQualifyIdentifier(this.getIdentifier());
    }

    private String fullyQualifyIdentifier(String identifier2) {
        return new File(identifier2).getAbsoluteFile().toURI().toString();
    }

    @Override
    public TupleEntryIterator openForRead(FlowProcess<Properties> flowProcess, InputStream input2) throws IOException {
        if (input2 == null) {
            input2 = new FileInputStream(this.getIdentifier());
        }
        return new TupleEntrySchemeIterator<Properties, InputStream>(flowProcess, this.getScheme(), input2, this.getIdentifier());
    }

    @Override
    public TupleEntryCollector openForWrite(FlowProcess<Properties> flowProcess, OutputStream output) throws IOException {
        if (output == null) {
            output = new TapFileOutputStream(this.getIdentifier(), this.isUpdate());
        }
        return new TupleEntrySchemeCollector<Properties, OutputStream>(flowProcess, this.getScheme(), output, this.getIdentifier());
    }

    @Override
    public long getSize(Properties conf) throws IOException {
        File file = new File(this.getIdentifier());
        if (file.isDirectory()) {
            return 0L;
        }
        return file.length();
    }

    @Override
    public boolean createResource(Properties conf) throws IOException {
        File parentFile = new File(this.getIdentifier()).getParentFile();
        return parentFile.exists() || parentFile.mkdirs();
    }

    @Override
    public boolean deleteResource(Properties conf) throws IOException {
        return new File(this.getIdentifier()).delete();
    }

    @Override
    public boolean commitResource(Properties conf) throws IOException {
        return true;
    }

    @Override
    public boolean resourceExists(Properties conf) throws IOException {
        return new File(this.getIdentifier()).exists();
    }

    @Override
    public long getModifiedTime(Properties conf) throws IOException {
        return new File(this.getIdentifier()).lastModified();
    }

    @Override
    public boolean isDirectory(Properties conf) throws IOException {
        return new File(this.getIdentifier()).isDirectory();
    }

    @Override
    public String[] getChildIdentifiers(Properties conf) throws IOException {
        return this.getChildIdentifiers(conf, 1, false);
    }

    @Override
    public String[] getChildIdentifiers(Properties conf, int depth, boolean fullyQualified) throws IOException {
        if (!this.resourceExists(conf)) {
            return new String[0];
        }
        LinkedHashSet<String> results2 = new LinkedHashSet<String>();
        this.getChildPaths(results2, this.getIdentifier(), depth);
        String[] allPaths2 = results2.toArray(new String[results2.size()]);
        if (!fullyQualified) {
            return allPaths2;
        }
        for (int i = 0; i < allPaths2.length; ++i) {
            allPaths2[i] = this.fullyQualifyIdentifier(allPaths2[i]);
        }
        return allPaths2;
    }

    private boolean getChildPaths(Set<String> results2, String identifier2, int depth) {
        File file = new File(identifier2);
        if (depth == 0 || file.isFile()) {
            results2.add(identifier2);
            return true;
        }
        String[] paths = file.list();
        if (paths == null) {
            return false;
        }
        boolean result2 = false;
        for (String path : paths) {
            result2 |= this.getChildPaths(results2, new File(file, path).getPath(), depth - 1);
        }
        return result2;
    }
}

