/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.util;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.scheme.hadoop.SequenceFile;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.lib.NullOutputFormat;

public class TempHfs
extends Hfs {
    final String name;
    private Class<? extends Scheme> schemeClass;

    public TempHfs(JobConf conf, String name2, boolean isNull2) {
        super(isNull2 ? new NullScheme() : new SequenceFile(){});
        this.name = name2;
        this.stringPath = this.initTemporaryPath(conf, true);
    }

    public TempHfs(JobConf conf, String name2, Class<? extends Scheme> schemeClass) {
        this(conf, name2, schemeClass, true);
    }

    public TempHfs(JobConf conf, String name2, Class<? extends Scheme> schemeClass, boolean unique2) {
        this.name = name2;
        this.schemeClass = schemeClass == null ? SequenceFile.class : schemeClass;
        this.stringPath = this.initTemporaryPath(conf, unique2);
    }

    public Class<? extends Scheme> getSchemeClass() {
        return this.schemeClass;
    }

    private String initTemporaryPath(JobConf conf, boolean unique2) {
        String child = unique2 ? this.makeTemporaryPathDirString(this.name) : this.name;
        return new Path(TempHfs.getTempPath(conf), child).toString();
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        Fields fields2 = incomingScopes.iterator().next().getIncomingTapFields();
        this.setSchemeUsing(fields2);
        return new Scope(fields2);
    }

    private void setSchemeUsing(Fields fields2) {
        try {
            this.setScheme(this.schemeClass.getConstructor(Fields.class).newInstance(fields2));
        }
        catch (Exception exception) {
            throw new CascadingException("unable to create specified scheme: " + this.schemeClass.getName(), exception);
        }
    }

    @Override
    public boolean isTemporary() {
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[\"" + this.getScheme() + "\"]" + "[" + this.name + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TempHfs tempHfs = (TempHfs)object;
        return !(this.name != null ? !this.name.equals(tempHfs.name) : tempHfs.name != null);
    }

    @Override
    public int hashCode() {
        return 31 * (System.identityHashCode(this) + this.name != null ? this.name.hashCode() : 0);
    }

    private static class NullScheme
    extends Scheme<JobConf, RecordReader, OutputCollector, Object, Object> {
        private NullScheme() {
        }

        @Override
        public void sourceConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
        }

        @Override
        public void sinkConfInit(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf conf) {
            conf.setOutputKeyClass(Tuple.class);
            conf.setOutputValueClass(Tuple.class);
            conf.setOutputFormat(NullOutputFormat.class);
        }

        @Override
        public boolean source(FlowProcess<JobConf> flowProcess, SourceCall<Object, RecordReader> sourceCall) throws IOException {
            return false;
        }

        @Override
        public void sink(FlowProcess<JobConf> flowProcess, SinkCall<Object, OutputCollector> sinkCall) throws IOException {
        }
    }
}

