/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.util;

import cascading.flow.FlowProcess;
import java.io.IOException;
import org.apache.hadoop.mapred.RecordReader;

public class MeasuredRecordReader
implements RecordReader {
    private final FlowProcess flowProcess;
    private final Enum counter;
    private RecordReader recordReader;

    public MeasuredRecordReader(FlowProcess flowProcess, Enum counter2) {
        this.flowProcess = flowProcess;
        this.counter = counter2;
    }

    public RecordReader getRecordReader() {
        return this.recordReader;
    }

    public void setRecordReader(RecordReader recordReader) {
        this.recordReader = recordReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next(Object key, Object value2) throws IOException {
        long start = System.currentTimeMillis();
        try {
            boolean bl = this.recordReader.next(key, value2);
            return bl;
        }
        finally {
            this.flowProcess.increment(this.counter, System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createKey() {
        long start = System.currentTimeMillis();
        try {
            Object object = this.recordReader.createKey();
            return object;
        }
        finally {
            this.flowProcess.increment(this.counter, System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createValue() {
        long start = System.currentTimeMillis();
        try {
            Object object = this.recordReader.createValue();
            return object;
        }
        finally {
            this.flowProcess.increment(this.counter, System.currentTimeMillis() - start);
        }
    }

    public long getPos() throws IOException {
        return this.recordReader.getPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        long start = System.currentTimeMillis();
        try {
            this.recordReader.close();
        }
        finally {
            this.flowProcess.increment(this.counter, System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getProgress() throws IOException {
        long start = System.currentTimeMillis();
        try {
            float f2 = this.recordReader.getProgress();
            return f2;
        }
        finally {
            this.flowProcess.increment(this.counter, System.currentTimeMillis() - start);
        }
    }
}

