/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.util;

import cascading.flow.FlowProcess;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.mapred.OutputCollector;

public class MeasuredOutputCollector
implements OutputCollector,
Closeable {
    private final FlowProcess flowProcess;
    private final Enum counter;
    private OutputCollector outputCollector;

    public MeasuredOutputCollector(FlowProcess flowProcess, Enum counter2) {
        this.flowProcess = flowProcess;
        this.counter = counter2;
    }

    public MeasuredOutputCollector(FlowProcess flowProcess, Enum counter2, OutputCollector outputCollector) {
        this.flowProcess = flowProcess;
        this.counter = counter2;
        this.outputCollector = outputCollector;
    }

    public OutputCollector getOutputCollector() {
        return this.outputCollector;
    }

    public void setOutputCollector(OutputCollector outputCollector) {
        this.outputCollector = outputCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(Object key, Object value2) throws IOException {
        long start = System.currentTimeMillis();
        try {
            this.outputCollector.collect(key, value2);
        }
        finally {
            this.flowProcess.increment(this.counter, System.currentTimeMillis() - start);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.outputCollector instanceof Closeable) {
            ((Closeable)this.outputCollector).close();
        }
    }
}

