/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.util.Hadoop18TapUtil;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapOutputCollector
implements OutputCollector,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TapOutputCollector.class);
    public static final String PART_TASK_PATTERN = "%s%spart-%05d";
    public static final String PART_TASK_SEQ_PATTERN = "%s%spart-%05d-%05d";
    private JobConf conf;
    private RecordWriter writer;
    private String filenamePattern;
    private String filename;
    private Tap<JobConf, RecordReader, OutputCollector> tap;
    private String prefix;
    private long sequence;
    private boolean isFileOutputFormat;
    private final FlowProcess<JobConf> flowProcess;

    public TapOutputCollector(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap) throws IOException {
        this(flowProcess, tap, null);
    }

    public TapOutputCollector(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, String prefix) throws IOException {
        this(flowProcess, tap, prefix, -1L);
    }

    public TapOutputCollector(FlowProcess<JobConf> flowProcess, Tap<JobConf, RecordReader, OutputCollector> tap, String prefix, long sequence2) throws IOException {
        this.tap = tap;
        this.sequence = sequence2;
        this.prefix = prefix == null || prefix.length() == 0 ? null : prefix;
        this.flowProcess = flowProcess;
        this.conf = this.flowProcess.getConfigCopy();
        this.filenamePattern = this.conf.get("cascading.tapcollector.partname", sequence2 == -1L ? PART_TASK_PATTERN : PART_TASK_SEQ_PATTERN);
        this.initialize();
    }

    protected void initialize() throws IOException {
        this.tap.sinkConfInit(this.flowProcess, this.conf);
        OutputFormat outputFormat = this.conf.getOutputFormat();
        this.isFileOutputFormat = outputFormat instanceof FileOutputFormat;
        if (this.isFileOutputFormat) {
            Hadoop18TapUtil.setupJob(this.conf);
            Hadoop18TapUtil.setupTask(this.conf);
            this.filename = this.prefix != null ? String.format(this.filenamePattern, this.prefix, "/", this.conf.getInt("mapred.task.partition", 0), this.sequence) : String.format(this.filenamePattern, "", "", this.conf.getInt("mapred.task.partition", 0), this.sequence);
        }
        LOG.info("creating path: {}", (Object)this.filename);
        this.writer = outputFormat.getRecordWriter(null, this.conf, this.filename, (Progressable)this.getReporter());
    }

    private Reporter getReporter() {
        Reporter reporter = Reporter.NULL;
        if (this.flowProcess instanceof HadoopFlowProcess) {
            reporter = ((HadoopFlowProcess)this.flowProcess).getReporter();
        }
        return reporter;
    }

    public void collect(Object writableComparable, Object writable) throws IOException {
        this.flowProcess.keepAlive();
        this.writer.write(writableComparable, writable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.isFileOutputFormat) {
                LOG.info("closing tap collector for: {}", (Object)new Path(this.tap.getIdentifier(), this.filename));
            } else {
                LOG.info("closing tap collector for: {}", (Object)this.tap);
            }
            try {
                this.writer.close(this.getReporter());
            }
            finally {
                if (this.isFileOutputFormat) {
                    if (Hadoop18TapUtil.needsTaskCommit(this.conf)) {
                        Hadoop18TapUtil.commitTask(this.conf);
                    }
                    Hadoop18TapUtil.cleanupJob(this.conf);
                }
            }
        }
        catch (IOException exception) {
            LOG.warn("exception closing: {}", (Object)this.filename, (Object)exception);
            throw new TapException("exception closing: " + this.filename, exception);
        }
    }
}

