/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public abstract class StreamedFileSystem
extends FileSystem {
    public FSDataOutputStream create(Path path, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    public boolean rename(Path path, Path path1) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    @Deprecated
    public boolean delete(Path path) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    public boolean delete(Path path, boolean b) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    public Path getWorkingDirectory() {
        return new Path("/").makeQualified((FileSystem)this);
    }

    public void setWorkingDirectory(Path f2) {
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        return new FileStatus[]{this.getFileStatus(path)};
    }

    public FSDataOutputStream append(Path f2, int bufferSize, Progressable progress) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    public static String getMD5SumFor(Configuration conf, Path path) {
        return StreamedFileSystem.getMD5SumFor(conf, path.toString());
    }

    public static String getMD5SumFor(Configuration conf, String path) {
        return conf.get(path + ".md5");
    }

    public static void setMD5SumFor(Configuration conf, Path path, String md5Hex) {
        StreamedFileSystem.setMD5SumFor(conf, path.toString(), md5Hex);
    }

    public static void setMD5SumFor(Configuration conf, String path, String md5Hex) {
        if (md5Hex == null || md5Hex.length() == 0) {
            return;
        }
        conf.set(path + ".md5", md5Hex);
    }
}

