/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import cascading.flow.hadoop.util.HadoopUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiInputSplit
implements InputSplit,
JobConfigurable {
    public static final String CASCADING_SOURCE_PATH = "cascading.source.path";
    private static final Logger LOG = LoggerFactory.getLogger(MultiInputSplit.class);
    private transient JobConf jobConf;
    InputSplit inputSplit;
    Map<String, String> config;

    public static String getCurrentTapSourcePath(JobConf jobConf) {
        return jobConf.get(CASCADING_SOURCE_PATH);
    }

    public MultiInputSplit(InputSplit inputSplit, Map<String, String> config2) {
        if (inputSplit == null) {
            throw new IllegalArgumentException("input split may not be null");
        }
        if (config2 == null) {
            throw new IllegalArgumentException("config may not be null");
        }
        this.inputSplit = inputSplit;
        this.config = config2;
    }

    public MultiInputSplit() {
    }

    public void configure(JobConf jobConf) {
        this.jobConf = jobConf;
    }

    public long getLength() throws IOException {
        return this.inputSplit.getLength();
    }

    public String[] getLocations() throws IOException {
        return this.inputSplit.getLocations();
    }

    public InputSplit getWrappedInputSplit() {
        return this.inputSplit;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.inputSplit.getClass().getName());
        String[] keys2 = this.config.keySet().toArray(new String[this.config.size()]);
        String[] values2 = new String[keys2.length];
        for (int i = 0; i < keys2.length; ++i) {
            values2[i] = this.config.get(keys2[i]);
        }
        WritableUtils.writeStringArray((DataOutput)out, (String[])keys2);
        WritableUtils.writeStringArray((DataOutput)out, (String[])values2);
        this.inputSplit.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        Path path;
        String splitType = in.readUTF();
        this.config = new HashMap<String, String>();
        String[] keys2 = WritableUtils.readStringArray((DataInput)in);
        String[] values2 = WritableUtils.readStringArray((DataInput)in);
        for (int i = 0; i < keys2.length; ++i) {
            this.config.put(keys2[i], values2[i]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("current split config diff:");
            for (Map.Entry<String, String> entry2 : this.config.entrySet()) {
                LOG.debug("key: {}, value: {}", (Object)entry2.getKey(), (Object)entry2.getValue());
            }
        }
        JobConf currentConf = HadoopUtil.mergeConf(this.jobConf, this.config, false);
        try {
            this.inputSplit = (InputSplit)ReflectionUtils.newInstance((Class)currentConf.getClassByName(splitType), (Configuration)currentConf);
        }
        catch (ClassNotFoundException exp) {
            throw new IOException("split class " + splitType + " not found");
        }
        this.inputSplit.readFields(in);
        if (this.inputSplit instanceof FileSplit && (path = ((FileSplit)this.inputSplit).getPath()) != null) {
            this.jobConf.set(CASCADING_SOURCE_PATH, path.toString());
            LOG.info("current split input path: {}", (Object)path);
        }
    }
}

