/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop.io;

import cascading.CascadingException;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.tap.hadoop.io.MultiInputSplit;
import cascading.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.jets3t.service.S3ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiInputFormat
implements InputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(MultiInputFormat.class);

    public static void addInputFormat(JobConf toJob, JobConf ... fromJobs) {
        toJob.setInputFormat(MultiInputFormat.class);
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>();
        ArrayList allPaths2 = new ArrayList();
        boolean isLocal2 = false;
        for (JobConf fromJob : fromJobs) {
            if (fromJob.get("mapred.input.format.class") == null) {
                throw new CascadingException("mapred.input.format.class is required, should be set in source Scheme#sourceConfInit");
            }
            configs.add(HadoopUtil.getConfig(toJob, fromJob));
            Collections.addAll(allPaths2, FileInputFormat.getInputPaths((JobConf)fromJob));
            if (isLocal2) continue;
            isLocal2 = HadoopUtil.isLocal(fromJob);
        }
        if (!allPaths2.isEmpty()) {
            FileInputFormat.setInputPaths((JobConf)toJob, (Path[])allPaths2.toArray(new Path[allPaths2.size()]));
        }
        try {
            toJob.set("cascading.multiinputformats", HadoopUtil.serializeBase64(configs, toJob, true));
        }
        catch (IOException exception) {
            throw new CascadingException("unable to pack input formats", exception);
        }
        if (isLocal2) {
            HadoopUtil.setLocal(toJob);
        }
    }

    static InputFormat[] getInputFormats(JobConf[] jobConfs) {
        InputFormat[] inputFormats = new InputFormat[jobConfs.length];
        for (int i = 0; i < jobConfs.length; ++i) {
            inputFormats[i] = jobConfs[i].getInputFormat();
        }
        return inputFormats;
    }

    private List<Map<String, String>> getConfigs(JobConf job) throws IOException {
        return HadoopUtil.deserializeBase64(job.get("cascading.multiinputformats"), (Configuration)job, ArrayList.class, true);
    }

    public void validateInput(JobConf job) throws IOException {
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        numSplits = numSplits == 0 ? 1 : numSplits;
        List<Map<String, String>> configs = this.getConfigs(job);
        JobConf[] jobConfs = HadoopUtil.getJobConfs(job, configs);
        InputFormat[] inputFormats = MultiInputFormat.getInputFormats(jobConfs);
        if (inputFormats.length == 1) {
            return this.collapse(this.getSplits(inputFormats, jobConfs, new int[]{numSplits}), configs);
        }
        int[] indexedSplits = new int[inputFormats.length];
        if (numSplits <= inputFormats.length) {
            Arrays.fill(indexedSplits, 1);
            return this.collapse(this.getSplits(inputFormats, jobConfs, indexedSplits), configs);
        }
        long[] inputSplitSizes = this.getInputSplitSizes(inputFormats, jobConfs, numSplits);
        long totalSplitSize = this.sum(inputSplitSizes);
        if (totalSplitSize == 0L) {
            Arrays.fill(indexedSplits, 1);
            return this.collapse(this.getSplits(inputFormats, jobConfs, indexedSplits), configs);
        }
        for (int i = 0; i < inputSplitSizes.length; ++i) {
            int useSplits = (int)Math.ceil((double)numSplits * (double)inputSplitSizes[i] / (double)totalSplitSize);
            indexedSplits[i] = useSplits == 0 ? 1 : useSplits;
        }
        return this.collapse(this.getSplits(inputFormats, jobConfs, indexedSplits), configs);
    }

    private long sum(long[] inputSizes2) {
        long size2 = 0L;
        for (long inputSize : inputSizes2) {
            size2 += inputSize;
        }
        return size2;
    }

    private InputSplit[] collapse(InputSplit[][] splits, List<Map<String, String>> configs) {
        ArrayList<MultiInputSplit> splitsList = new ArrayList<MultiInputSplit>();
        for (int i = 0; i < splits.length; ++i) {
            Map<String, String> config2 = configs.get(i);
            config2.remove("mapred.input.dir");
            config2.remove("mapreduce.input.fileinputformat.inputdir");
            InputSplit[] split2 = splits[i];
            for (int j = 0; j < split2.length; ++j) {
                splitsList.add(new MultiInputSplit(split2[j], config2));
            }
        }
        return splitsList.toArray(new InputSplit[splitsList.size()]);
    }

    private InputSplit[][] getSplits(InputFormat[] inputFormats, JobConf[] jobConfs, int[] numSplits) throws IOException {
        InputSplit[][] inputSplits = new InputSplit[inputFormats.length][];
        for (int i = 0; i < inputFormats.length; ++i) {
            inputSplits[i] = inputFormats[i].getSplits(jobConfs[i], numSplits[i]);
            if (inputSplits[i] == null) {
                inputSplits[i] = new InputSplit[0];
            }
            for (int j = 0; j < inputSplits[i].length; ++j) {
                if (inputSplits[i][j] != null) continue;
                throw new IllegalStateException("input format: " + inputFormats[i].getClass().getName() + ", returned a split array with nulls");
            }
        }
        return inputSplits;
    }

    private long[] getInputSplitSizes(InputFormat[] inputFormats, JobConf[] jobConfs, int numSplits) throws IOException {
        long[] inputSizes2 = new long[inputFormats.length];
        for (int i = 0; i < inputFormats.length; ++i) {
            InputFormat inputFormat = inputFormats[i];
            InputSplit[] splits = inputFormat.getSplits(jobConfs[i], numSplits);
            inputSizes2[i] = splits.length;
        }
        return inputSizes2;
    }

    public RecordReader getRecordReader(InputSplit split2, JobConf job, final Reporter reporter) throws IOException {
        final MultiInputSplit multiSplit = (MultiInputSplit)split2;
        final JobConf currentConf = HadoopUtil.mergeConf(job, multiSplit.config, true);
        try {
            return Util.retry(LOG, 3, 20, "unable to get record reader", new Util.RetryOperator<RecordReader>(){

                @Override
                public RecordReader operate() throws Exception {
                    return currentConf.getInputFormat().getRecordReader(multiSplit.inputSplit, currentConf, reporter);
                }

                @Override
                public boolean rethrow(Exception exception) {
                    return !(exception.getCause() instanceof S3ServiceException);
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw (IOException)exception;
        }
    }
}

