/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.flow.FlowProcess;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeIterator;
import cascading.tap.hadoop.io.TapOutputCollector;
import cascading.tap.partition.BasePartitionTap;
import cascading.tap.partition.Partition;
import cascading.tuple.TupleEntrySchemeCollector;
import cascading.tuple.TupleEntrySchemeIterator;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class PartitionTap
extends BasePartitionTap<JobConf, RecordReader, OutputCollector> {
    @ConstructorProperties(value={"parent", "partition"})
    public PartitionTap(Hfs parent, Partition partition2) {
        this(parent, partition2, 300);
    }

    @ConstructorProperties(value={"parent", "partition", "openWritesThreshold"})
    public PartitionTap(Hfs parent, Partition partition2, int openWritesThreshold) {
        super((Tap)parent, partition2, openWritesThreshold);
    }

    @ConstructorProperties(value={"parent", "partition", "sinkMode"})
    public PartitionTap(Hfs parent, Partition partition2, SinkMode sinkMode) {
        super((Tap)parent, partition2, sinkMode);
    }

    @ConstructorProperties(value={"parent", "partition", "sinkMode", "keepParentOnDelete"})
    public PartitionTap(Hfs parent, Partition partition2, SinkMode sinkMode, boolean keepParentOnDelete) {
        this(parent, partition2, sinkMode, keepParentOnDelete, 300);
    }

    @ConstructorProperties(value={"parent", "partition", "sinkMode", "keepParentOnDelete", "openWritesThreshold"})
    public PartitionTap(Hfs parent, Partition partition2, SinkMode sinkMode, boolean keepParentOnDelete, int openWritesThreshold) {
        super(parent, partition2, sinkMode, keepParentOnDelete, openWritesThreshold);
    }

    @Override
    protected TupleEntrySchemeCollector createTupleEntrySchemeCollector(FlowProcess<JobConf> flowProcess, Tap parent, String path, long sequence2) throws IOException {
        TapOutputCollector outputCollector = new TapOutputCollector(flowProcess, parent, path, sequence2);
        return new TupleEntrySchemeCollector<JobConf, TapOutputCollector>(flowProcess, parent, outputCollector);
    }

    @Override
    protected TupleEntrySchemeIterator createTupleEntrySchemeIterator(FlowProcess<JobConf> flowProcess, Tap parent, String path, RecordReader recordReader) throws IOException {
        return new HadoopTupleEntrySchemeIterator(flowProcess, new Hfs(parent.getScheme(), path), recordReader);
    }

    @Override
    protected String getCurrentIdentifier(FlowProcess<JobConf> flowProcess) {
        String identifier2 = flowProcess.getStringProperty("cascading.source.path");
        if (identifier2 == null) {
            return null;
        }
        return new Path(identifier2).getParent().toString();
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> flowProcess, JobConf conf) {
        try {
            String[] childPartitions = this.getChildPartitionIdentifiers(flowProcess, true);
            ((Hfs)this.getParent()).applySourceConfInitIdentifiers(flowProcess, conf, childPartitions);
        }
        catch (IOException exception) {
            throw new TapException("unable to retrieve child partitions", exception);
        }
    }
}

