/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.SequenceFile;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.io.CombineFileRecordReaderWrapper;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeCollector;
import cascading.tap.hadoop.io.HadoopTupleEntrySchemeIterator;
import cascading.tap.type.FileType;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileInputFormat;
import org.apache.hadoop.mapred.lib.CombineFileRecordReader;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hfs
extends Tap<JobConf, RecordReader, OutputCollector>
implements FileType<JobConf> {
    private static final Logger LOG = LoggerFactory.getLogger(Hfs.class);
    @Deprecated
    public static final String TEMPORARY_DIRECTORY = "cascading.tmp.dir";
    protected String stringPath;
    transient URI uriScheme;
    transient Path path;
    private transient FileStatus[] statuses;
    private static final PathFilter HIDDEN_FILES_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            String name2 = path.getName();
            if (name2.isEmpty()) {
                return true;
            }
            char first2 = name2.charAt(0);
            return first2 != '_' && first2 != '.';
        }
    };

    @Deprecated
    public static void setTemporaryDirectory(Map<Object, Object> properties, String tempDir) {
        properties.put(TEMPORARY_DIRECTORY, tempDir);
    }

    @Deprecated
    public static String getTemporaryDirectory(Map<Object, Object> properties) {
        return (String)properties.get(TEMPORARY_DIRECTORY);
    }

    protected static String getLocalModeScheme(JobConf conf, String defaultValue2) {
        return conf.get("cascading.hadoop.localmode.scheme", defaultValue2);
    }

    protected static boolean getUseCombinedInput(JobConf conf) {
        return conf.getBoolean("cascading.hadoop.hfs.combine.files", false);
    }

    protected static boolean getCombinedInputSafeMode(JobConf conf) {
        return conf.getBoolean("cascading.hadoop.hfs.combine.safemode", true);
    }

    protected Hfs() {
    }

    @ConstructorProperties(value={"scheme"})
    protected Hfs(Scheme<JobConf, RecordReader, OutputCollector, ?, ?> scheme) {
        super(scheme);
    }

    @Deprecated
    @ConstructorProperties(value={"fields", "stringPath"})
    public Hfs(Fields fields2, String stringPath) {
        super(new SequenceFile(fields2));
        this.setStringPath(stringPath);
    }

    @Deprecated
    @ConstructorProperties(value={"fields", "stringPath", "replace"})
    public Hfs(Fields fields2, String stringPath, boolean replace) {
        super(new SequenceFile(fields2), replace ? SinkMode.REPLACE : SinkMode.KEEP);
        this.setStringPath(stringPath);
    }

    @Deprecated
    @ConstructorProperties(value={"fields", "stringPath", "sinkMode"})
    public Hfs(Fields fields2, String stringPath, SinkMode sinkMode) {
        super(new SequenceFile(fields2), sinkMode);
        this.setStringPath(stringPath);
        if (sinkMode == SinkMode.UPDATE) {
            throw new IllegalArgumentException("updates are not supported");
        }
    }

    @ConstructorProperties(value={"scheme", "stringPath"})
    public Hfs(Scheme<JobConf, RecordReader, OutputCollector, ?, ?> scheme, String stringPath) {
        super(scheme);
        this.setStringPath(stringPath);
    }

    @Deprecated
    @ConstructorProperties(value={"scheme", "stringPath", "replace"})
    public Hfs(Scheme<JobConf, RecordReader, OutputCollector, ?, ?> scheme, String stringPath, boolean replace) {
        super(scheme, replace ? SinkMode.REPLACE : SinkMode.KEEP);
        this.setStringPath(stringPath);
    }

    @ConstructorProperties(value={"scheme", "stringPath", "sinkMode"})
    public Hfs(Scheme<JobConf, RecordReader, OutputCollector, ?, ?> scheme, String stringPath, SinkMode sinkMode) {
        super(scheme, sinkMode);
        this.setStringPath(stringPath);
    }

    protected void setStringPath(String stringPath) {
        this.stringPath = Util.normalizeUrl(stringPath);
    }

    protected void setUriScheme(URI uriScheme) {
        this.uriScheme = uriScheme;
    }

    public URI getURIScheme(JobConf jobConf) {
        if (this.uriScheme != null) {
            return this.uriScheme;
        }
        this.uriScheme = this.makeURIScheme(jobConf);
        return this.uriScheme;
    }

    protected URI makeURIScheme(JobConf jobConf) {
        try {
            LOG.debug("handling path: {}", (Object)this.stringPath);
            URI uri = new Path(this.stringPath).toUri();
            String schemeString = uri.getScheme();
            String authority = uri.getAuthority();
            LOG.debug("found scheme: {}, authority: {}", (Object)schemeString, (Object)authority);
            URI uriScheme = schemeString != null && authority != null ? new URI(schemeString + "://" + uri.getAuthority()) : (schemeString != null ? new URI(schemeString + ":///") : this.getDefaultFileSystemURIScheme(jobConf));
            LOG.debug("using uri scheme: {}", (Object)uriScheme);
            return uriScheme;
        }
        catch (URISyntaxException exception) {
            throw new TapException("could not determine scheme from path: " + this.getPath(), exception);
        }
    }

    public URI getDefaultFileSystemURIScheme(JobConf jobConf) {
        return this.getDefaultFileSystem(jobConf).getUri();
    }

    protected FileSystem getDefaultFileSystem(JobConf jobConf) {
        try {
            return FileSystem.get((Configuration)jobConf);
        }
        catch (IOException exception) {
            throw new TapException("unable to get handle to underlying filesystem", exception);
        }
    }

    protected FileSystem getFileSystem(JobConf jobConf) {
        URI scheme = this.getURIScheme(jobConf);
        try {
            return FileSystem.get((URI)scheme, (Configuration)jobConf);
        }
        catch (IOException exception) {
            throw new TapException("unable to get handle to get filesystem for: " + scheme.getScheme(), exception);
        }
    }

    @Override
    public String getIdentifier() {
        return this.getPath().toString();
    }

    public Path getPath() {
        if (this.path != null) {
            return this.path;
        }
        if (this.stringPath == null) {
            throw new IllegalStateException("path not initialized");
        }
        this.path = new Path(this.stringPath);
        return this.path;
    }

    @Override
    public String getFullIdentifier(JobConf conf) {
        return this.getPath().makeQualified(this.getFileSystem(conf)).toString();
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> process2, JobConf conf) {
        String fullIdentifier = this.getFullIdentifier(conf);
        this.applySourceConfInitIdentifiers(process2, conf, fullIdentifier);
        Hfs.verifyNoDuplicates(conf);
    }

    protected static void verifyNoDuplicates(JobConf conf) {
        Path[] inputPaths = FileInputFormat.getInputPaths((JobConf)conf);
        HashSet<Path> paths = new HashSet<Path>((int)((float)inputPaths.length / 0.75f));
        for (Path inputPath : inputPaths) {
            if (paths.add(inputPath)) continue;
            throw new TapException("may not add duplicate paths, found: " + inputPath);
        }
    }

    protected void applySourceConfInitIdentifiers(FlowProcess<JobConf> process2, JobConf conf, String ... fullIdentifiers) {
        for (String fullIdentifier : fullIdentifiers) {
            this.sourceConfInitAddInputPath(conf, new Path(fullIdentifier));
        }
        this.sourceConfInitComplete(process2, conf);
    }

    protected void sourceConfInitAddInputPath(JobConf conf, Path qualifiedPath) {
        FileInputFormat.addInputPath((JobConf)conf, (Path)qualifiedPath);
        this.makeLocal(conf, qualifiedPath, "forcing job to local mode, via source: ");
    }

    protected void sourceConfInitComplete(FlowProcess<JobConf> process2, JobConf conf) {
        super.sourceConfInit(process2, conf);
        TupleSerialization.setSerializations(conf);
        this.handleCombineFileInputFormat(conf);
    }

    private void handleCombineFileInputFormat(JobConf conf) {
        if (!Hfs.getUseCombinedInput(conf)) {
            return;
        }
        String individualInputFormat = conf.get("mapred.input.format.class");
        if (individualInputFormat == null) {
            throw new TapException("input format is missing from the underlying scheme");
        }
        if (individualInputFormat.equals(CombinedInputFormat.class.getName()) && conf.get("cascading.individual.input.format") == null) {
            throw new TapException("the input format class is already the combined input format but the underlying input format is missing");
        }
        boolean safeMode = Hfs.getCombinedInputSafeMode(conf);
        if (!FileInputFormat.class.isAssignableFrom(conf.getClass("mapred.input.format.class", null))) {
            if (safeMode) {
                throw new TapException("input format must be of type org.apache.hadoop.mapred.FileInputFormat, got: " + individualInputFormat);
            }
            LOG.warn("not combining input splits with CombineFileInputFormat, {} is not of type org.apache.hadoop.mapred.FileInputFormat.", (Object)individualInputFormat);
        } else {
            conf.set("cascading.individual.input.format", individualInputFormat);
            conf.setInputFormat(CombinedInputFormat.class);
        }
    }

    @Override
    public void sinkConfInit(FlowProcess<JobConf> process2, JobConf conf) {
        Path qualifiedPath = new Path(this.getFullIdentifier(conf));
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)qualifiedPath);
        super.sinkConfInit(process2, conf);
        this.makeLocal(conf, qualifiedPath, "forcing job to local mode, via sink: ");
        TupleSerialization.setSerializations(conf);
    }

    private void makeLocal(JobConf conf, Path qualifiedPath, String infoMessage) {
        String scheme = Hfs.getLocalModeScheme(conf, "file");
        if (!HadoopUtil.isLocal(conf) && qualifiedPath.toUri().getScheme().equalsIgnoreCase(scheme)) {
            if (LOG.isInfoEnabled()) {
                LOG.info(infoMessage + this.toString());
            }
            HadoopUtil.setLocal(conf);
        }
    }

    @Override
    public TupleEntryIterator openForRead(FlowProcess<JobConf> flowProcess, RecordReader input2) throws IOException {
        return new HadoopTupleEntrySchemeIterator(flowProcess, this, input2);
    }

    @Override
    public TupleEntryCollector openForWrite(FlowProcess<JobConf> flowProcess, OutputCollector output) throws IOException {
        return new HadoopTupleEntrySchemeCollector(flowProcess, (Tap<JobConf, RecordReader, OutputCollector>)this, output);
    }

    @Override
    public boolean createResource(JobConf conf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("making dirs: {}", (Object)this.getFullIdentifier(conf));
        }
        return this.getFileSystem(conf).mkdirs(this.getPath());
    }

    @Override
    public boolean deleteResource(JobConf conf) throws IOException {
        String fullIdentifier = this.getFullIdentifier(conf);
        return this.deleteFullIdentifier(conf, fullIdentifier);
    }

    private boolean deleteFullIdentifier(JobConf conf, String fullIdentifier) throws IOException {
        Path fullPath;
        if (LOG.isDebugEnabled()) {
            LOG.debug("deleting: {}", (Object)fullIdentifier);
        }
        if ((fullPath = new Path(fullIdentifier)).depth() == 0) {
            return true;
        }
        FileSystem fileSystem = this.getFileSystem(conf);
        try {
            return fileSystem.delete(fullPath, true);
        }
        catch (NullPointerException exception) {
            if (!(fileSystem instanceof NativeS3FileSystem)) {
                throw exception;
            }
            return true;
        }
    }

    public boolean deleteChildResource(JobConf conf, String childIdentifier) throws IOException {
        Path childPath = new Path(childIdentifier).makeQualified(this.getFileSystem(conf));
        if (!childPath.toString().startsWith(this.getFullIdentifier(conf))) {
            return false;
        }
        return this.deleteFullIdentifier(conf, childPath.toString());
    }

    @Override
    public boolean resourceExists(JobConf conf) throws IOException {
        FileStatus[] fileStatuses = this.getFileSystem(conf).globStatus(this.getPath());
        return fileStatuses != null && fileStatuses.length > 0;
    }

    @Override
    public boolean isDirectory(JobConf conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return false;
        }
        return this.getFileSystem(conf).getFileStatus(this.getPath()).isDir();
    }

    @Override
    public long getSize(JobConf conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0L;
        }
        FileStatus fileStatus = this.getFileSystem(conf).getFileStatus(this.getPath());
        if (fileStatus.isDir()) {
            return 0L;
        }
        return this.getFileSystem(conf).getFileStatus(this.getPath()).getLen();
    }

    public long getBlockSize(JobConf conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0L;
        }
        FileStatus fileStatus = this.getFileSystem(conf).getFileStatus(this.getPath());
        if (fileStatus.isDir()) {
            return 0L;
        }
        return fileStatus.getBlockSize();
    }

    public int getReplication(JobConf conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0;
        }
        FileStatus fileStatus = this.getFileSystem(conf).getFileStatus(this.getPath());
        if (fileStatus.isDir()) {
            return 0;
        }
        return fileStatus.getReplication();
    }

    @Override
    public String[] getChildIdentifiers(JobConf conf) throws IOException {
        return this.getChildIdentifiers(conf, 1, false);
    }

    @Override
    public String[] getChildIdentifiers(JobConf conf, int depth, boolean fullyQualified) throws IOException {
        if (!this.resourceExists(conf)) {
            return new String[0];
        }
        if (depth == 0 && !fullyQualified) {
            return new String[]{this.getIdentifier()};
        }
        String fullIdentifier = this.getFullIdentifier(conf);
        int trim2 = fullyQualified ? 0 : fullIdentifier.length() + 1;
        LinkedHashSet<String> results2 = new LinkedHashSet<String>();
        this.getChildPaths(conf, results2, trim2, new Path(fullIdentifier), depth);
        return results2.toArray(new String[results2.size()]);
    }

    private void getChildPaths(JobConf conf, Set<String> results2, int trim2, Path path, int depth) throws IOException {
        if (depth == 0) {
            String substring = path.toString().substring(trim2);
            String identifier2 = this.getIdentifier();
            if (identifier2 == null || identifier2.isEmpty()) {
                results2.add(new Path(substring).toString());
            } else {
                results2.add(new Path(identifier2, substring).toString());
            }
            return;
        }
        FileStatus[] statuses = this.getFileSystem(conf).listStatus(path, HIDDEN_FILES_FILTER);
        if (statuses == null) {
            return;
        }
        for (FileStatus fileStatus : statuses) {
            this.getChildPaths(conf, results2, trim2, fileStatus.getPath(), depth - 1);
        }
    }

    @Override
    public long getModifiedTime(JobConf conf) throws IOException {
        if (!this.resourceExists(conf)) {
            return 0L;
        }
        FileStatus fileStatus = this.getFileSystem(conf).getFileStatus(this.getPath());
        if (!fileStatus.isDir()) {
            return fileStatus.getModificationTime();
        }
        this.makeStatuses(conf);
        if (this.statuses == null || this.statuses.length == 0) {
            return 0L;
        }
        long date = 0L;
        for (FileStatus status : this.statuses) {
            if (status.isDir()) continue;
            date = Math.max(date, status.getModificationTime());
        }
        return date;
    }

    public static Path getTempPath(JobConf conf) {
        String tempDir = conf.get(TEMPORARY_DIRECTORY);
        if (tempDir == null) {
            tempDir = conf.get("hadoop.tmp.dir");
        }
        return new Path(tempDir);
    }

    protected String makeTemporaryPathDirString(String name2) {
        if ((name2 = name2.replaceAll("^[_\\W\\s]+", "")).isEmpty()) {
            name2 = "temp-path";
        }
        return name2.replaceAll("[\\W\\s]+", "_") + Util.createUniqueID();
    }

    private void makeStatuses(JobConf conf) throws IOException {
        if (this.statuses != null) {
            return;
        }
        this.statuses = this.getFileSystem(conf).listStatus(this.getPath());
    }

    static class CombinedInputFormat
    extends CombineFileInputFormat
    implements Configurable {
        private Configuration conf;

        CombinedInputFormat() {
        }

        public RecordReader getRecordReader(InputSplit split2, JobConf job, Reporter reporter) throws IOException {
            return new CombineFileRecordReader(job, (CombineFileSplit)split2, reporter, CombineFileRecordReaderWrapper.class);
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
            this.setMaxSplitSize(conf.getLong("cascading.hadoop.hfs.combine.max.size", 0L));
        }

        public Configuration getConf() {
            return this.conf;
        }
    }
}

