/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.tap.MultiSourceTap;
import cascading.tap.TapException;
import cascading.tap.hadoop.Hfs;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;

public class GlobHfs
extends MultiSourceTap<Hfs, JobConf, RecordReader> {
    private final String pathPattern;
    private final PathFilter pathFilter;

    @ConstructorProperties(value={"scheme", "pathPattern"})
    public GlobHfs(Scheme<JobConf, RecordReader, ?, ?, ?> scheme, String pathPattern) {
        this(scheme, pathPattern, null);
    }

    @ConstructorProperties(value={"scheme", "pathPattern", "pathFilter"})
    public GlobHfs(Scheme<JobConf, RecordReader, ?, ?, ?> scheme, String pathPattern, PathFilter pathFilter) {
        super(scheme);
        this.pathPattern = pathPattern;
        this.pathFilter = pathFilter;
    }

    @Override
    public String getIdentifier() {
        return this.pathPattern;
    }

    protected Hfs[] getTaps() {
        return this.initTapsInternal(new JobConf());
    }

    private Hfs[] initTapsInternal(JobConf conf) {
        if (this.taps != null) {
            return (Hfs[])this.taps;
        }
        try {
            this.taps = this.makeTaps(conf);
        }
        catch (IOException exception) {
            throw new TapException("unable to resolve taps for globing path: " + this.pathPattern);
        }
        return (Hfs[])this.taps;
    }

    private Hfs[] makeTaps(JobConf conf) throws IOException {
        Path path = new Path(this.pathPattern);
        FileSystem fileSystem = path.getFileSystem((Configuration)conf);
        FileStatus[] statusList = this.pathFilter == null ? fileSystem.globStatus(path) : fileSystem.globStatus(path, this.pathFilter);
        if (statusList == null || statusList.length == 0) {
            throw new TapException("unable to find paths matching path pattern: " + this.pathPattern);
        }
        ArrayList<Hfs> notEmpty = new ArrayList<Hfs>();
        for (int i = 0; i < statusList.length; ++i) {
            if (!statusList[i].isDir() && statusList[i].getLen() == 0L) continue;
            notEmpty.add(new Hfs(this.getScheme(), statusList[i].getPath().toString()));
        }
        if (notEmpty.isEmpty()) {
            throw new TapException("all paths matching path pattern are zero length and not directories: " + this.pathPattern);
        }
        return notEmpty.toArray(new Hfs[notEmpty.size()]);
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> process2, JobConf conf) {
        Hfs[] taps;
        for (Hfs tap : taps = this.initTapsInternal(conf)) {
            taps[0].sourceConfInitAddInputPath(conf, tap.getPath());
        }
        taps[0].sourceConfInitComplete(process2, conf);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        GlobHfs globHfs = (GlobHfs)object;
        if (this.getScheme() != null ? !this.getScheme().equals(globHfs.getScheme()) : globHfs.getScheme() != null) {
            return false;
        }
        if (this.pathFilter != null ? !this.pathFilter.equals(globHfs.pathFilter) : globHfs.pathFilter != null) {
            return false;
        }
        return !(this.pathPattern != null ? !this.pathPattern.equals(globHfs.pathPattern) : globHfs.pathPattern != null);
    }

    @Override
    public int hashCode() {
        int result2 = this.pathPattern != null ? this.pathPattern.hashCode() : 0;
        result2 = 31 * result2 + (this.pathFilter != null ? this.pathFilter.hashCode() : 0);
        return result2;
    }

    @Override
    public String toString() {
        return "GlobHfs[" + this.pathPattern + ']';
    }
}

