/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap.hadoop;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.tap.DecoratorTap;
import cascading.tap.MultiSourceTap;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.Lfs;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistCacheTap
extends DecoratorTap<Void, JobConf, RecordReader, OutputCollector> {
    private static final Logger LOG = LoggerFactory.getLogger(DistCacheTap.class);

    public DistCacheTap(Hfs parent) {
        super(parent);
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> process2, JobConf conf) {
        if (HadoopUtil.isLocal(conf) || Tap.id(this).equals(conf.get("cascading.step.source"))) {
            LOG.info("can't use distributed cache. reading '{}' from hdfs.", (Object)this.getIdentifier());
            super.sourceConfInit(process2, conf);
            return;
        }
        try {
            this.registerHfs(process2, conf, this.getHfs());
        }
        catch (IOException exception) {
            throw new TapException(exception);
        }
    }

    @Override
    public TupleEntryIterator openForRead(FlowProcess<JobConf> flowProcess, RecordReader input2) throws IOException {
        if (HadoopUtil.isLocal(flowProcess.getConfigCopy()) || input2 != null) {
            LOG.info("delegating to parent.");
            return super.openForRead(flowProcess, input2);
        }
        Path[] cachedFiles = DistributedCache.getLocalCacheFiles((Configuration)((Configuration)flowProcess.getConfigCopy()));
        if (cachedFiles == null || cachedFiles.length == 0) {
            return super.openForRead(flowProcess, input2);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        ArrayList<Lfs> taps = new ArrayList<Lfs>();
        if (this.isSimpleGlob()) {
            FileStatus[] statuses;
            FileSystem fs = FileSystem.get((Configuration)((Configuration)flowProcess.getConfigCopy()));
            for (FileStatus fileStatus : statuses = fs.globStatus(this.getHfs().getPath())) {
                paths.add(fileStatus.getPath());
            }
        } else {
            paths.add(this.getHfs().getPath());
        }
        for (Path pathToFind : paths) {
            for (FileStatus fileStatus : cachedFiles) {
                if (!fileStatus.toString().endsWith(pathToFind.getName())) continue;
                LOG.info("found {} in distributed cache", (Object)fileStatus);
                taps.add(new Lfs(this.getScheme(), fileStatus.toString()));
            }
        }
        if (paths.isEmpty()) {
            LOG.info("could not find files in distributed cache. delegating to parent: {}", (Object)super.getIdentifier());
            return super.openForRead(flowProcess, input2);
        }
        return new MultiSourceTap(taps.toArray(new Tap[taps.size()])).openForRead(flowProcess, input2);
    }

    private void registerHfs(FlowProcess<JobConf> process2, JobConf conf, Hfs hfs) throws IOException {
        if (this.isSimpleGlob()) {
            FileSystem fs = FileSystem.get((Configuration)conf);
            FileStatus[] statuses = fs.globStatus(this.getHfs().getPath());
            if (statuses == null || statuses.length == 0) {
                throw new TapException(String.format("glob expression %s does not match any files on the filesystem", this.getHfs().getPath()));
            }
            for (FileStatus fileStatus : statuses) {
                this.registerURI(conf, fileStatus.getPath());
            }
        } else {
            this.registerURI(conf, hfs.getPath());
        }
        hfs.sourceConfInitComplete(process2, conf);
    }

    private void registerURI(JobConf conf, Path path) {
        URI uri = path.toUri();
        LOG.info("adding {} to distributed cache ", (Object)uri);
        DistributedCache.addCacheFile((URI)uri, (Configuration)conf);
    }

    private Hfs getHfs() {
        return (Hfs)this.getOriginal();
    }

    private boolean isSimpleGlob() {
        return this.getHfs().getIdentifier().contains("*");
    }
}

