/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.flow.Flow;
import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.management.annotation.Property;
import cascading.management.annotation.PropertyDescription;
import cascading.management.annotation.PropertySanitizer;
import cascading.management.annotation.Visibility;
import cascading.property.ConfigDef;
import cascading.scheme.Scheme;
import cascading.tap.DecoratorTap;
import cascading.tap.SinkMode;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.tuple.FieldsResolverException;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.util.TraceUtil;
import cascading.util.Traceable;
import cascading.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;

public abstract class Tap<Config, Input, Output>
implements FlowElement,
Serializable,
Traceable {
    private Scheme<Config, Input, Output, ?, ?> scheme;
    SinkMode sinkMode = SinkMode.KEEP;
    private ConfigDef configDef;
    private ConfigDef processConfigDef;
    private final String id = Util.createUniqueID();
    private String trace = TraceUtil.captureDebugTrace(this);

    public static Tap[] taps(Tap ... taps) {
        return taps;
    }

    public static synchronized String id(Tap tap) {
        if (tap instanceof DecoratorTap) {
            return Tap.id(((DecoratorTap)tap).getOriginal());
        }
        return tap.id;
    }

    protected Tap() {
    }

    protected Tap(Scheme<Config, Input, Output, ?, ?> scheme) {
        this.setScheme(scheme);
    }

    protected Tap(Scheme<Config, Input, Output, ?, ?> scheme, SinkMode sinkMode) {
        this.setScheme(scheme);
        this.sinkMode = sinkMode;
    }

    protected void setScheme(Scheme<Config, Input, Output, ?, ?> scheme) {
        this.scheme = scheme;
    }

    public Scheme<Config, Input, Output, ?, ?> getScheme() {
        return this.scheme;
    }

    @Override
    public String getTrace() {
        return this.trace;
    }

    public void flowConfInit(Flow<Config> flow) {
    }

    public void sourceConfInit(FlowProcess<Config> flowProcess, Config conf) {
        this.getScheme().sourceConfInit(flowProcess, this, conf);
    }

    public void sinkConfInit(FlowProcess<Config> flowProcess, Config conf) {
        this.getScheme().sinkConfInit(flowProcess, this, conf);
    }

    @Property(name="identifier", visibility=Visibility.PUBLIC)
    @PropertyDescription(value="The resource this Tap instance represents")
    @PropertySanitizer(value="cascading.management.annotation.URISanitizer")
    public abstract String getIdentifier();

    public Fields getSourceFields() {
        return this.getScheme().getSourceFields();
    }

    public Fields getSinkFields() {
        return this.getScheme().getSinkFields();
    }

    public abstract TupleEntryIterator openForRead(FlowProcess<Config> var1, Input var2) throws IOException;

    public TupleEntryIterator openForRead(FlowProcess<Config> flowProcess) throws IOException {
        return this.openForRead(flowProcess, null);
    }

    public abstract TupleEntryCollector openForWrite(FlowProcess<Config> var1, Output var2) throws IOException;

    public TupleEntryCollector openForWrite(FlowProcess<Config> flowProcess) throws IOException {
        if (this.isReplace()) {
            this.deleteResource(flowProcess.getConfigCopy());
        }
        return this.openForWrite(flowProcess, null);
    }

    @Override
    public Scope outgoingScopeFor(Set<Scope> incomingScopes) {
        Fields incomingFields;
        int count2 = 0;
        for (Scope incomingScope : incomingScopes) {
            Fields incomingFields2 = incomingScope.getIncomingTapFields();
            if (incomingFields2 == null) continue;
            try {
                incomingFields2.select(this.getSinkFields());
            }
            catch (FieldsResolverException exception) {
                throw new TapException(this, exception.getSourceFields(), exception.getSelectorFields(), exception);
            }
            ++count2;
        }
        if (count2 > 1) {
            throw new FlowException("Tap may not have more than one incoming Scope");
        }
        Fields fields2 = incomingFields = incomingScopes.size() == 0 ? null : incomingScopes.iterator().next().getIncomingTapFields();
        if (incomingFields != null && (this.isSource() && this.getSourceFields().equals(Fields.UNKNOWN) || this.isSink() && this.getSinkFields().equals(Fields.ALL))) {
            return new Scope(incomingFields);
        }
        if (count2 == 1) {
            return new Scope(this.getSinkFields());
        }
        return new Scope(this.getSourceFields());
    }

    public Fields retrieveSourceFields(FlowProcess<Config> flowProcess) {
        return this.getScheme().retrieveSourceFields(flowProcess, this);
    }

    public void presentSourceFields(FlowProcess<Config> flowProcess, Fields fields2) {
        this.getScheme().presentSourceFields(flowProcess, this, fields2);
    }

    public Fields retrieveSinkFields(FlowProcess<Config> flowProcess) {
        return this.getScheme().retrieveSinkFields(flowProcess, this);
    }

    public void presentSinkFields(FlowProcess<Config> flowProcess, Fields fields2) {
        this.getScheme().presentSinkFields(flowProcess, this, fields2);
    }

    @Override
    public Fields resolveIncomingOperationArgumentFields(Scope incomingScope) {
        return incomingScope.getIncomingTapFields();
    }

    @Override
    public Fields resolveIncomingOperationPassThroughFields(Scope incomingScope) {
        return incomingScope.getIncomingTapFields();
    }

    public String getFullIdentifier(FlowProcess<Config> flowProcess) {
        return this.getFullIdentifier(flowProcess.getConfigCopy());
    }

    public String getFullIdentifier(Config conf) {
        return this.getIdentifier();
    }

    public boolean createResource(FlowProcess<Config> flowProcess) throws IOException {
        return this.createResource(flowProcess.getConfigCopy());
    }

    public abstract boolean createResource(Config var1) throws IOException;

    public boolean deleteResource(FlowProcess<Config> flowProcess) throws IOException {
        return this.deleteResource(flowProcess.getConfigCopy());
    }

    public abstract boolean deleteResource(Config var1) throws IOException;

    public boolean commitResource(Config conf) throws IOException {
        return true;
    }

    public boolean rollbackResource(Config conf) throws IOException {
        return true;
    }

    public boolean resourceExists(FlowProcess<Config> flowProcess) throws IOException {
        return this.resourceExists(flowProcess.getConfigCopy());
    }

    public abstract boolean resourceExists(Config var1) throws IOException;

    public long getModifiedTime(FlowProcess<Config> flowProcess) throws IOException {
        return this.getModifiedTime(flowProcess.getConfigCopy());
    }

    public abstract long getModifiedTime(Config var1) throws IOException;

    public SinkMode getSinkMode() {
        return this.sinkMode;
    }

    public boolean isKeep() {
        return this.sinkMode == SinkMode.KEEP;
    }

    public boolean isReplace() {
        return this.sinkMode == SinkMode.REPLACE;
    }

    public boolean isUpdate() {
        return this.sinkMode == SinkMode.UPDATE;
    }

    public boolean isSink() {
        return this.getScheme().isSink();
    }

    public boolean isSource() {
        return this.getScheme().isSource();
    }

    public boolean isTemporary() {
        return false;
    }

    @Override
    public ConfigDef getConfigDef() {
        if (this.configDef == null) {
            this.configDef = new ConfigDef();
        }
        return this.configDef;
    }

    @Override
    public boolean hasConfigDef() {
        return this.configDef != null && !this.configDef.isEmpty();
    }

    @Override
    public ConfigDef getStepConfigDef() {
        if (this.processConfigDef == null) {
            this.processConfigDef = new ConfigDef();
        }
        return this.processConfigDef;
    }

    @Override
    public boolean hasStepConfigDef() {
        return this.processConfigDef != null && !this.processConfigDef.isEmpty();
    }

    @Override
    public boolean isEquivalentTo(FlowElement element) {
        boolean compare2;
        if (element == null) {
            return false;
        }
        if (this == element) {
            return true;
        }
        boolean bl = compare2 = this.getClass() == element.getClass();
        if (!compare2) {
            return false;
        }
        return this.equals(element);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Tap tap = (Tap)object;
        if (this.getIdentifier() != null ? !this.getIdentifier().equals(tap.getIdentifier()) : tap.getIdentifier() != null) {
            return false;
        }
        return !(this.getScheme() != null ? !this.getScheme().equals(tap.getScheme()) : tap.getScheme() != null);
    }

    public int hashCode() {
        int result2 = this.getIdentifier() != null ? this.getIdentifier().hashCode() : 0;
        result2 = 31 * result2 + (this.getScheme() != null ? this.getScheme().hashCode() : 0);
        return result2;
    }

    public String toString() {
        if (this.getIdentifier() != null) {
            return this.getClass().getSimpleName() + "[\"" + this.getScheme() + "\"]" + "[\"" + Util.sanitizeUrl(this.getIdentifier()) + "\"]";
        }
        return this.getClass().getSimpleName() + "[\"" + this.getScheme() + "\"]" + "[not initialized]";
    }
}

