/*
 * Decompiled with CFR 0.152.
 */
package cascading.tap;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.tap.CompositeTap;
import cascading.tap.SourceTap;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryChainIterator;
import cascading.tuple.TupleEntryIterator;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

public class MultiSourceTap<Child extends Tap, Config, Input>
extends SourceTap<Config, Input>
implements CompositeTap<Child> {
    private final String identifier = "__multisource_placeholder_" + Util.createUniqueID();
    protected Child[] taps;

    protected MultiSourceTap(Scheme<Config, Input, ?, ?, ?> scheme) {
        super(scheme);
    }

    @ConstructorProperties(value={"taps"})
    public MultiSourceTap(Child ... taps) {
        this.taps = (Tap[])Arrays.copyOf(taps, taps.length);
        this.verifyTaps();
    }

    private void verifyTaps() {
        Child tap = this.taps[0];
        for (int i = 1; i < this.taps.length; ++i) {
            if (tap.getClass() != this.taps[i].getClass()) {
                throw new TapException("all taps must be of the same type");
            }
            if (((Tap)tap).getScheme().equals(((Tap)this.taps[i]).getScheme())) continue;
            throw new TapException("all tap schemes must be equivalent");
        }
    }

    protected Child[] getTaps() {
        return this.taps;
    }

    @Override
    public Iterator<Child> getChildTaps() {
        Tap[] taps = this.getTaps();
        if (taps == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Arrays.asList(taps).iterator();
    }

    @Override
    public long getNumChildTaps() {
        return this.getTaps().length;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Scheme getScheme() {
        Scheme scheme = super.getScheme();
        if (scheme != null) {
            return scheme;
        }
        return ((Tap)this.taps[0]).getScheme();
    }

    @Override
    public boolean isReplace() {
        return false;
    }

    @Override
    public void sourceConfInit(FlowProcess<Config> process2, Config conf) {
        for (Tap tap : this.getTaps()) {
            tap.sourceConfInit(process2, conf);
        }
    }

    @Override
    public boolean resourceExists(Config conf) throws IOException {
        for (Tap tap : this.getTaps()) {
            if (tap.resourceExists(conf)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getModifiedTime(Config conf) throws IOException {
        Tap[] taps = this.getTaps();
        if (taps == null || taps.length == 0) {
            return 0L;
        }
        long modified = taps[0].getModifiedTime(conf);
        for (int i = 1; i < this.getTaps().length; ++i) {
            modified = Math.max(this.getTaps()[i].getModifiedTime(conf), modified);
        }
        return modified;
    }

    @Override
    public TupleEntryIterator openForRead(FlowProcess<Config> flowProcess, Input input2) throws IOException {
        if (input2 != null) {
            return ((Tap)this.taps[0]).openForRead(flowProcess, input2);
        }
        Iterator[] iterators = new Iterator[this.getTaps().length];
        for (int i = 0; i < this.getTaps().length; ++i) {
            iterators[i] = new TupleIterator(this.getTaps()[i].openForRead(flowProcess));
        }
        return new TupleEntryChainIterator(this.getSourceFields(), iterators);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MultiSourceTap multiTap = (MultiSourceTap)object;
        return Arrays.equals(this.getTaps(), multiTap.getTaps());
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.getTaps() != null ? Arrays.hashCode(this.getTaps()) : 0);
        return result2;
    }

    @Override
    public String toString() {
        Object[] printableTaps = this.getTaps();
        if (printableTaps == null) {
            return "MultiSourceTap[none]";
        }
        String printedTaps = printableTaps.length > 10 ? Arrays.toString(Arrays.copyOf(printableTaps, 10)) + ",..." : Arrays.toString(printableTaps);
        return "MultiSourceTap[" + printableTaps.length + ':' + printedTaps + ']';
    }

    private class TupleIterator
    implements Iterator {
        final TupleEntryIterator iterator;

        private TupleIterator(TupleEntryIterator iterator2) {
            this.iterator = iterator2;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return ((TupleEntry)this.iterator.next()).getTuple();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

